using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data.SqlClient;
using System.Data;

using BookShopOnline.DBHelper;
using BookShopOnline.Model;
using BookShopOnline.WebConfig;

namespace BookShopOnline.SQLServerDal
{
    public abstract class DBAccess
    {
        public DataSet GetDataSet(StoredProcedureName storedProcedureName, params SqlParameter[] cmdParms)
        {
            return SQLHelper.GetDataSet(Config.SQLServerConnStr, CommandType.StoredProcedure, storedProcedureName.ToString(),cmdParms);
        }

        public int ExecuteNonQuery(StoredProcedureName storedProcedureName, params SqlParameter[] cmdParms)
        {
            return SQLHelper.ExecuteNonQuery(Config.SQLServerConnStr, CommandType.StoredProcedure, storedProcedureName.ToString(), cmdParms);
        }

        public SqlDataReader ExecuteReader(StoredProcedureName storedProcedureName, params SqlParameter[] cmdParms)
        {
            return SQLHelper.ExecuteReader(Config.SQLServerConnStr, CommandType.StoredProcedure, storedProcedureName.ToString(), cmdParms);
        }
    }
}
