using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;

using BookShopOnline.Model;
using BookShopOnline.WebConfig;
using BookShopOnline.SQLServerDal;
using BookShopOnline.DBHelper;
using BookShopOnline.IDal;

namespace BookShopOnline.SQLServerDal
{
    public class FavoritesDal : DBAccess,IFavorites
    {
        #region IFavorites Ա

        #region ղ
        public int InsertFavorites(Favorites favorites)
        {
            SqlParameter[] parms ={
                new SqlParameter("@UserID",favorites.UserID),
                new SqlParameter("@BookID",favorites.BookID)
            };

            return base.ExecuteNonQuery(StoredProcedureName.sp_InsertFavorites, parms);
        }
        #endregion

        #region ȡûղ
        public DataSet SelectFavoritesByUserID(int userID)
        {
            SqlParameter parm = new SqlParameter("@UserID", userID);

            return base.GetDataSet(StoredProcedureName.sp_SelectFavoritesByUserID, parm);
        }
        #endregion

        #region ɾĳһղؼ¼
        public int DeleteFavoritesByID(int favoritesID)
        {
            SqlParameter parm = new SqlParameter("@FavoritesID", favoritesID);

            return base.ExecuteNonQuery(StoredProcedureName.sp_DeleteFavoritesByID, parm);
        }
        #endregion

        #endregion

    }
}
