using System;
using System.Collections.Generic;
using System.Text;
using System.Data.SqlClient;
using System.Data;

using BookShopOnline.Model;
using BookShopOnline.IDal;
using BookShopOnline.DBHelper;
using BookShopOnline.WebConfig;

namespace BookShopOnline.SQLServerDal
{
    public class ShoppingCartDal:IShoppingCart
    {

        #region ӹﳵ
        public int InsertShoppingCart(ShoppingCart shoppingCart)
        {
            int cartID = 0;

            SqlParameter[] parms ={
                new SqlParameter("@BookID",shoppingCart.BookID),
                new SqlParameter("@CartGuid",shoppingCart.CartGuid),
                new SqlParameter("@Quatity",shoppingCart.Quatity)
            };

            using (SqlDataReader dr = SQLHelper.ExecuteReader(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_InsertShoppingCart.ToString(), parms))
            {
                if (dr.Read())
                {
                    cartID = Convert.ToInt32(dr[0]);
                }
            }

            return cartID;
        }
        #endregion

        #region ͨCartGuidȡﳵ
        public DataSet SelectShoppingCartByCartGuid(string cartGuid)
        {
            SqlParameter parm=new SqlParameter("@CartGuid",cartGuid);

            return SQLHelper.GetDataSet(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_SelectShoppingCartByCartGuid.ToString(), parm);
        }
        #endregion

        #region ¹ﳵ
        public int UpdateShoppingCart(ShoppingCart shoppingCart)
        {
            return 0;
        }

        public int UpdateShoppingCart(IList<ShoppingCart> shoppingCartList)
        {
            int result=0;
            using (SqlConnection conn = new SqlConnection(Config.SQLServerConnStr))
            {
                foreach (ShoppingCart shoppingCart in shoppingCartList)
                {
                    SqlParameter[] parms =
                    {
                        new SqlParameter("@CartID",shoppingCart.CartID),
                        new SqlParameter("@Quatity",shoppingCart.Quatity)
                    };

                    result += SQLHelper.ExecuteNonQuery(conn, CommandType.StoredProcedure, StoredProcedureName.sp_UpdateShoppingCart.ToString(), parms);
                }

                return result;
            }
        }
        #endregion

        #region CartIDɾﳵ¼
        public int DeleteShoppingCartByCartID(int cartID)
        {
            SqlParameter parm = new SqlParameter("@CartID", cartID);

            return SQLHelper.ExecuteNonQuery(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_DeleteShoppingCartByCartID.ToString(), parm);
        }
        #endregion

        #region CartGuidɾﳵ¼
        public int DeleteShoppingCartByCartGuid(string cartGuid)
        {
            SqlParameter parm = new SqlParameter("@CartGuid", cartGuid);

            return SQLHelper.ExecuteNonQuery(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_DeleteShoppingCartByCartGuid.ToString(), parm);
        }
        #endregion
    }
}
