using System;
using System.Collections.Generic;
using System.Text;
using System.Data.SqlClient;
using System.Data;

using BookShopOnline.Model;
using BookShopOnline.IDal;
using BookShopOnline.DBHelper;
using BookShopOnline.WebConfig;
using BookShopOnline.Utility;

namespace BookShopOnline.SQLServerDal
{
    public class UserDal:DBAccess,IUser
    {
        #region û
        public int InsertUser(User user)
        {
            SqlParameter[] parms ={
                new SqlParameter("@RoleID",user.RoleID),
                new SqlParameter("@UserName",user.UserName),
                new SqlParameter("@UserPwd",user.UserPwd),
                new SqlParameter("@RealName",user.RealName),
                new SqlParameter("@Email",user.Email),
                new SqlParameter("@Address",user.Address),
                new SqlParameter("@PostalCode",user.PostalCode),
                new SqlParameter("@Phone",user.Phone)
            };

            return SQLHelper.ExecuteNonQuery(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_InsertUser.ToString(), parms);
        }
        #endregion

        #region ûǷ
        /// <summary>
        /// ڷtrue򷵻false
        /// </summary>
        /// <param name="userName"></param>
        /// <returns></returns>
        public bool CheckUserName(string userName)
        {
            bool isExist;
            SqlParameter parm = new SqlParameter("@UserName", userName);

            using (SqlDataReader dr = SQLHelper.ExecuteReader(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_CheckUserName.ToString(), parm))
            {
                if (dr.Read())
                    isExist = true;
                else
                    isExist = false;
            }

            return isExist;
        }
        #endregion

        #region EmailǷ
        /// <summary>
        /// ڷtrue򷵻false
        /// </summary>
        /// <param name="email"></param>
        /// <returns></returns>
        public bool CheckEmail(string email)
        {
            bool isExist;
            SqlParameter parm = new SqlParameter("@Email", email);

            using (SqlDataReader dr = SQLHelper.ExecuteReader(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_CheckEmail.ToString(), parm))
            {
                if (dr.Read())
                    isExist = true;
                else
                    isExist = false;
            }

            return isExist;
        }
        #endregion

        #region ֤û½
        public User CheckUserLogin(string userName, string userPwd,Role role)
        {
            SqlParameter parm = new SqlParameter("@UserName", userName);

            StoredProcedureName spName=StoredProcedureName.sp_CheckUserLogin;

            if(role==Role.RegisterUser)
                spName=StoredProcedureName.sp_CheckUserLogin;
            else if(role==Role.AdminUser)
                spName=StoredProcedureName.sp_CheckAdminLogin;

            using (SqlDataReader dr = base.ExecuteReader(spName,parm))
            {
                if (dr.Read())
                {
                    if (dr.GetString(dr.GetOrdinal("UserPwd")) == Password.EncryptMD5(userPwd))
                    {
                        User user = new User();
                        user.UserID = dr.GetInt32(dr.GetOrdinal("UserID"));
                        user.RoleID = dr.GetInt16(dr.GetOrdinal("RoleID"));
                        user.UserName = dr.GetString(dr.GetOrdinal("UserName"));
                        user.UserPwd = dr.GetString(dr.GetOrdinal("UserPwd"));
                        user.IsLock = dr.GetBoolean(dr.GetOrdinal("IsLock"));
                        user.Address = dr.GetString(dr.GetOrdinal("Address"));
                        user.Email = dr.GetString(dr.GetOrdinal("Email"));
                        user.Phone = dr.GetString(dr.GetOrdinal("Phone"));
                        user.PostalCode = dr.GetString(dr.GetOrdinal("PostalCode"));
                        user.RealName = dr.GetString(dr.GetOrdinal("RealName"));

                        return user;
                    }
                    else
                        return null;
                }
                else
                {
                    return null;
                }
            }
        }
        #endregion

        #region ޸
        public bool EditPwd(int userID, string newPwd)
        {
            SqlParameter[] parms =
                {
                    new SqlParameter("@UserID",userID),
                    new SqlParameter("@NewPwd",newPwd)
                };

           int result=base.ExecuteNonQuery(StoredProcedureName.sp_EditPwd,parms);

           if (result > 0)
               return true;
           else
               return false;
        }
        #endregion

        #region ûϢ
        public int UpdateUser(User user)
        {
            //UserID,Emailջʱࡢ绰ַ
            SqlParameter[] parms ={
                new SqlParameter("@UserID",user.UserID),
                new SqlParameter("@RealName",user.RealName),
                new SqlParameter("@Email",user.Email),
                new SqlParameter("@Address",user.Address),
                new SqlParameter("@PostalCode",user.PostalCode),
                new SqlParameter("@Phone",user.Phone)
            };

            return base.ExecuteNonQuery(StoredProcedureName.sp_UpdateUser, parms);
        }
        #endregion
    }
}
