using System;
using System.Collections.Generic;
using System.Text;
using System.Data;

using BookShopOnline.Model;
using BookShopOnline.Bll;
using BookShopOnline.Utility;
using BookShopOnline.SQLServerDal;
using NUnit.Framework;

namespace BookShopOnline.TestClass
{
    [TestFixture]
    public class TestFavoritesBll
    {
        #region TestInsertFavorites
        [Test]//
        public void TestInsertFavorites()
        {
            Favorites favorites = new Favorites();
            favorites.BookID = 10;
            favorites.UserID = 7;

            int returnValue = new FavoritesBll().InsertFavorites(favorites);

            Assert.IsTrue(returnValue > 0);
        }

        [Test]//ظͼ
        public void TestInsertFavorites2()
        {
            Favorites favorites = new Favorites();
            favorites.BookID = 10;
            favorites.UserID = 7;

            int returnValue = new FavoritesBll().InsertFavorites(favorites);

            Assert.IsTrue(returnValue<0);
        }
        #endregion

        #region TestSelectFavoritesByUserID
        [Test]//
        public void TestSelectFavoritesByUserID()
        {
            FavoritesBll favoritesBll = new FavoritesBll();

            Favorites favorites = new Favorites();
            favorites.BookID = 10;
            favorites.UserID = 13;

            favoritesBll.InsertFavorites(favorites);

            DataSet ds =favoritesBll.SelectFavoritesByUserID(13);

            Assert.IsTrue(ds.Tables[0].Rows.Count > 0);
        }
        #endregion

        #region TestDeleteFavoritesByID
        [Test]
        public void TestDeleteFavoritesByID()
        {
            FavoritesBll favoritesBll = new FavoritesBll();

            Favorites favorites = new Favorites();
            favorites.BookID = 9;
            favorites.UserID = 7;

            favoritesBll.InsertFavorites(favorites);

            int returnValue = favoritesBll.DeleteFavoritesByID(favoritesBll.SelectMaxID().ToString());

            Assert.IsTrue(returnValue > 0);
        }
        #endregion
    }
}
