using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data;

using BookShopOnline.Model;
using BookShopOnline.Bll;
using BookShopOnline.Utility;
using NUnit.Framework;

namespace BookShopOnline.TestClass
{
    [TestFixture]
    public class TestOrdersBll
    {
        #region 
        //
        [Test]
        public void TestPayForOrders()
        {
            bool result = new OrdersBll().PayForOrders(1, "200882021301862736", 300);

            Assert.IsTrue(result);
        }

        //OrderID=null
        [Test]
        public void TestPayForOrders2()
        {
            bool result = new OrdersBll().PayForOrders(1, null, 50);

            Assert.IsFalse(result);
        }

        //OrdeID=""
        [Test]
        public void TestPayForOrders3()
        {
            bool result = new OrdersBll().PayForOrders(1, "", 50);

            Assert.IsFalse(result);
        }

        //OrderID
        [Test]
        public void TestPayForOrders4()
        {
            bool result = new OrdersBll().PayForOrders(1, "23423423423", 50);

            Assert.IsFalse(result);
        }

        //PayPrice=0
        [Test]
        public void TestPayForOrders5()
        {
            bool result = new OrdersBll().PayForOrders(1, null, 0);

            Assert.IsFalse(result);
        }

        //PayPrice<0
        [Test]
        public void TestPayForOrders6()
        {
            bool result = new OrdersBll().PayForOrders(1, null, -10);

            Assert.IsFalse(result);
        }

        //UserID
        [Test]
        public void TestPayForOrders7()
        {
            bool result = new OrdersBll().PayForOrders(-1, "200882021301862736", 50);

            Assert.IsFalse(result);
        }
        #endregion

        #region ¶
        [Test]//ȷ
        public void TestUpdateOrders()
        {
            Orders orders = new Orders();
            orders.UserID = 1;
            orders.OrderID = "200882021301862736";

            orders.ReceiverName = "֣2";
            orders.ReceiverPostalCode = "363002";
            orders.ReceiverPhone = "05912193118,13463290592";
            orders.ReceiverAddress = "ʡ202";

            orders.PortTypeID = 2;
            orders.PayTypeID = 2;

            int result = new OrdersBll().UpdateOrders(orders);

            Assert.IsTrue(result > 0);
        }

        [Test]//OrderID=null
        public void TestUpdateOrders2()
        {
            Orders orders = new Orders();
            orders.UserID = 1;
            orders.OrderID = null;

            orders.ReceiverName = "֣2";
            orders.ReceiverPostalCode = "363002";
            orders.ReceiverPhone = "05912193118,13463290592";
            orders.ReceiverAddress = "ʡ202";

            orders.PortTypeID = 2;
            orders.PayTypeID = 2;

            int result = new OrdersBll().UpdateOrders(orders);

            Assert.IsTrue(result==-1);
        }

        [Test]//OrderID=""
        public void TestUpdateOrders3()
        {
            Orders orders = new Orders();
            orders.UserID = 1;
            orders.OrderID = "";

            orders.ReceiverName = "֣2";
            orders.ReceiverPostalCode = "363002";
            orders.ReceiverPhone = "05912193118,13463290592";
            orders.ReceiverAddress = "ʡ202";

            orders.PortTypeID = 2;
            orders.PayTypeID = 2;

            int result = new OrdersBll().UpdateOrders(orders);

            Assert.IsTrue(result==-1);
        }

        [Test]//UserID=-1
        public void TestUpdateOrders4()
        {
            Orders orders = new Orders();
            orders.UserID = -1;
            orders.OrderID = "200882021301862736";

            orders.ReceiverName = "֣2";
            orders.ReceiverPostalCode = "363002";
            orders.ReceiverPhone = "05912193118,13463290592";
            orders.ReceiverAddress = "ʡ202";

            orders.PortTypeID = 2;
            orders.PayTypeID = 2;

            int result = new OrdersBll().UpdateOrders(orders);

            Assert.IsTrue(result==-1);
        }

        [Test]//UserIDԭID
        public void TestUpdateOrders5()
        {
            Orders orders = new Orders();
            orders.UserID = 2;
            orders.OrderID = "200882021301862736";

            orders.ReceiverName = "֣2";
            orders.ReceiverPostalCode = "363002";
            orders.ReceiverPhone = "05912193118,13463290592";
            orders.ReceiverAddress = "ʡ202";

            orders.PortTypeID = 2;
            orders.PayTypeID = 2;

            int result = new OrdersBll().UpdateOrders(orders);

            Assert.IsTrue(result== 0);
        }

        [Test]//OrderIDԭID
        public void TestUpdateOrders6()
        {
            Orders orders = new Orders();
            orders.UserID = 1;
            orders.OrderID = "200882021301";

            orders.ReceiverName = "֣2";
            orders.ReceiverPostalCode = "363002";
            orders.ReceiverPhone = "05912193118,13463290592";
            orders.ReceiverAddress = "ʡ202";

            orders.PortTypeID = 2;
            orders.PayTypeID = 2;

            int result = new OrdersBll().UpdateOrders(orders);

            Assert.IsTrue(result== 0);
        }
        #endregion

        [Test]
        public void TestSelectAllOrders()
        {
            DataSet ds = new OrdersBll().SelectAllOrders();

            Assert.IsTrue(ds.Tables[0].Rows.Count > 0);
        }

        [Test]
        public void TestSelectOrderStaticByOrderID()
        {
            DataSet ds = new OrdersBll().SelectOrderStaticByOrderID("2008820213741718836");

            Assert.IsTrue(ds.Tables[0].Rows.Count == 4);
        }

        [Test]
        public void TestUpdateOrderStaicAndTip()
        {
            IList<Order_OrderStatic> list=new List<Order_OrderStatic>();

            Order_OrderStatic var1=new Order_OrderStatic();
            var1.StaticID=1;
            var1.YesOrNo=true;
            list.Add(var1);

            Order_OrderStatic var2 = new Order_OrderStatic();
            var1.StaticID = 2;
            var1.YesOrNo = true;
            list.Add(var2);

            Order_OrderStatic var3 = new Order_OrderStatic();
            var1.StaticID = 3;
            var1.YesOrNo = true;
            list.Add(var3);

            Order_OrderStatic var4 = new Order_OrderStatic();
            var1.StaticID = 4;
            var1.YesOrNo = false;
            list.Add(var4);

            bool result = new OrdersBll().UpdateOrderStaicAndTip("2008822122538984185", list, 6);

            Assert.IsTrue(result == true);
        }

        [Test]
        public void TestSelectOrdersByUserID()
        {
            DataSet ds = new OrdersBll().SelectOrdersByUserID(5);

            Assert.IsTrue(ds.Tables[0].Rows.Count > 0);
        }
    }
}
