using System;
using System.Collections.Generic;
using System.Text;
using System.Data;

using BookShopOnline.Model;
using BookShopOnline.WebConfig;
using BookShopOnline.SQLServerDal;
using BookShopOnline.Utility;
using NUnit.Framework;

namespace BookShopOnline.TestClass
{
    [TestFixture]
    public class TestOrderDal
    {
        [Test]
        public void TestInsertOrders()
        {
            Orders orders=new Orders();
            orders.TipID = (int)OrderStaticTip.WaitForConfirm;
            orders.PayTypeID = 1;
            orders.PortTypeID = 1;
            orders.ReceiverAddress = "ʡ205";
            orders.ReceiverName = "֣";
            orders.ReceiverPhone = "05912193118,13463290591";
            orders.ReceiverPostalCode = "363000";
            orders.UserID = 1;

            string cartGuid = "sadfsdfs9-23423-23423";// new Guid().ToString();
            DataSet shoppingCartList=new ShoppingCartDal().SelectShoppingCartByCartGuid(cartGuid);
            Assert.IsNotNull(new OrdersDal().InsertOrders(orders, shoppingCartList));
        }

        [Test]
        public void TestSelectOrdersByOrderID()
        {
            DataSet ds = new OrdersDal().SelectOrdersByOrderID("200882022556109636");

            Assert.IsTrue(ds.Tables[0].Rows.Count == 1);
        }
    }
}
