using System;
using System.Collections.Generic;
using System.Text;
using System.Data;

using BookShopOnline.Model;
using BookShopOnline.WebConfig;
using BookShopOnline.SQLServerDal;
using BookShopOnline.Bll;
using BookShopOnline.Utility;
using NUnit.Framework;

namespace BookShopOnline.TestClass
{
    [TestFixture] 
    public class TestUserBll
    {
        #region TestInsertUser
        [Test]//(עû
        public void TestInsertUser()
        {
            User user = new User();
            user.RoleID =(int)Role.RegisterUser;
            user.UserName = "ruimingde";
            user.UserPwd = "2193118";
            user.RealName = "֣";
            user.PostalCode = "363000";
            user.Phone = "123456789,2323423423423";
            user.Email = "ruimingde@126.com";
            user.Address = "ʡ205";

            int result = new UserBll().InsertUser(user);

            Assert.IsTrue(result == 1);
        }

        [Test]//ûѴ
        public void TestInsertUser2()
        {
            User user = new User();
            user.RoleID = (int)Role.RegisterUser;
            user.UserName = "ruimingde";
            user.UserPwd = "12345";
            user.RealName = "֣";
            user.PostalCode = "363000";
            user.Phone = "123456789,2323423423423";
            user.Email = "ruimingde2@126.com";
            user.Address = "ʡ205";

            int result = new UserBll().InsertUser(user);

            Assert.IsTrue(result == -2);
        }

        [Test]//EmailѴ
        public void TestInsertUser3()
        {
            User user = new User();
            user.RoleID = (int)Role.RegisterUser;
            user.UserName = "ruimingde3";
            user.UserPwd = "12345";
            user.RealName = "֣";
            user.PostalCode = "363000";
            user.Phone = "123456789,2323423423423";
            user.Email = "ruimingde@126.com";
            user.Address = "ʡ205";

            int result = new UserBll().InsertUser(user);

            Assert.IsTrue(result == -3);
        }

        [Test]//볤ȹ(עû
        public void TestInsertUser4()
        {
            User user = new User();
            user.RoleID = (int)Role.RegisterUser;
            user.UserName = "ruimingde4";
            user.UserPwd = "12345";
            user.RealName = "֣";
            user.PostalCode = "363000";
            user.Phone = "123456789,2323423423423";
            user.Email = "ruimingde@126.com";
            user.Address = "ʡ205";

            int result = new UserBll().InsertUser(user);

            Assert.IsTrue(result == -4);
        }

        [Test]//Ա
        public void TestInsertUser5()
        {
            User user = new User();
            user.RoleID = (int)Role.AdminUser;
            user.UserName = "admin";
            user.UserPwd = "admin";
            user.RealName = "֣";
            user.PostalCode = "363000";
            user.Phone = "123456789,2323423423423";
            user.Email = "admin@126.com";
            user.Address = "ʡ205";

            int result = new UserBll().InsertUser(user);

            Assert.IsTrue(result == 1);
        }

        [Test]//볤ȹ(Աû
        public void TestInsertUser6()
        {
            User user = new User();
            user.RoleID = (int)Role.AdminUser;
            user.UserName = "ruimingde6";
            user.UserPwd = "1234567";
            user.RealName = "֣";
            user.PostalCode = "363000";
            user.Phone = "123456789,2323423423423";
            user.Email = "ruimingde6@126.com";
            user.Address = "ʡ205";

            int result = new UserBll().InsertUser(user);

            Assert.IsTrue(result == -4);
        }
        #endregion

        #region TestCheckUserName
        [Test]//
        public void TestCheckUserName()
        {
            bool isExist = new UserBll().CheckUserName("ruimingde");

            Assert.IsTrue(isExist);
        }

        [Test]//
        public void TestCheckUserName2()
        {
            bool isExist = new UserBll().CheckUserName("ruimingde2");

            Assert.IsFalse(isExist);
        }

        [Test]//û溬пո
        public void TestCheckUserName3()
        {
            bool isExist = new UserBll().CheckUserName("ruimingde   ");

            Assert.IsTrue(isExist);
        }

        [Test]//ո
        public void TestCheckUserName4()
        {
            bool isExist = new UserBll().CheckUserName("");

            Assert.IsFalse(isExist);
        }

        [Test]//sqlע
        public void TestCheckUserName5()
        {
            bool isExist = new UserBll().CheckUserName("asjdkfsld'or 1=1 --");

            Assert.IsFalse(isExist);
        }

        [Test]//ȳ50
        public void TestCheckUserName6()
        {
            bool isExist = new UserBll().CheckUserName("ķ羰ٴ򿪷޷ֶνʵſĿ˹پͷݿʼʽ ʵſǵĻȿռ sakdfjksdfkjsdkfsdkjfjskdfjksdkjfdsfdsfkjsdfjksdjfsdkfd");

            Assert.IsFalse(isExist);
        }
        #endregion

        #region TestCheckEmail
        [Test]//
        public void TestCheckEmail()
        {
            bool isExist = new UserBll().CheckEmail("ruimingde@126.com");

            Assert.IsTrue(isExist);
        }

        [Test]//
        public void TestCheckEmail2()
        {
            bool isExist = new UserBll().CheckEmail("ruimingde2@126.com");

            Assert.IsFalse(isExist);
        }
        #endregion

        #region TestCheckUserLogin
        /*
        [Test]//
        public void TestCheckUserLogin()
        {
            bool result = new UserBll().CheckUserLogin("test", "123456",Role.RegisterUser);

            Assert.IsTrue(result);
        }

        [Test]//ûĴСд
        public void TestCheckUserLogin2()
        {
            bool result = new UserBll().CheckUserLogin("Test", "123456", Role.RegisterUser);

            Assert.IsTrue(result);
        }

        [Test]//ĴСдɹ
        public void TestCheckUserLogin3()
        {
            bool result = new UserBll().CheckUserLogin("test6", "test118", Role.RegisterUser);

            Assert.IsTrue(result);
        }

        [Test]//ĴСдʧܣ
        public void TestCheckUserLogin4()
        {
            bool result = new UserBll().CheckUserLogin("test6", "Test118", Role.RegisterUser);

            Assert.IsFalse(result);
        }

        [Test]//ûĳȳ50
        public void TestCheckUserLogin5()
        {
            bool result = new UserBll().CheckUserLogin("sjdfksjdfksksjdfksjdfksjdfksjdfksjdfkjsdkfjsdkfjsdkfjskadjfslkdjfksdjfksdfjsdkfjsdjfskdjfskdfjsdkfjsdj", "Test118", Role.RegisterUser);

            Assert.IsFalse(result);
        }

        [Test]//볤ȳ50
        public void TestCheckUserLogin6()
        {
            bool result = new UserBll().CheckUserLogin("test6", "sjdfksjdfksksjdfksjdfksjdfksjdfksjdfkjsdkfjsdkfjsdkfjskadjfslkdjfksdjfksdfjsdkfjsdjfskdjfskdfjsdkfjsdj", Role.RegisterUser);

            Assert.IsFalse(result);
        }
         */
        #endregion

        #region TestUpdateUser
        //δ޸Email
        [Test]
        public void TestUpdateUser()
        {
            User user=new User();
            user.UserID = 7;
            user.RealName = "֣2";
            user.PostalCode = "363002";
            user.Phone = "123456789,2323423423422";
            user.Email = "ruimingde@126.com";
            user.Address = "ʡ2052";

            string oldEmail = "ruimingde@126.com";

            int returnValue = new UserBll().UpdateUser(user,oldEmail);

            Assert.IsTrue(returnValue > 0);
        }

        //޸EmailҸEmailû
        [Test]
        public void TestUpdateUser2()
        {
            User user = new User();
            user.UserID = 7;
            user.RealName = "֣2";
            user.PostalCode = "363002";
            user.Phone = "123456789,2323423423422";
            user.Email = "ruimingde2@126.com";
            user.Address = "ʡ2052";

            string oldEmail = "ruimingde@126.com";

            int returnValue = new UserBll().UpdateUser(user, oldEmail);

            Assert.IsTrue(returnValue==-1);
        }

        //޸EmailҸEmail
        [Test]
        public void TestUpdateUser3()
        {
            User user = new User();
            user.UserID = 7;
            user.RealName = "֣2";
            user.PostalCode = "363002";
            user.Phone = "123456789,2323423423422";
            user.Email = "ruimingde118@126.com";
            user.Address = "ʡ2052";

            string oldEmail = "ruimingde@126.com";

            int returnValue = new UserBll().UpdateUser(user, oldEmail);

            Assert.IsTrue(returnValue > 0);
        }
        #endregion
    }
}
