//====================================================================
//      Copyright(C) 2008-2009 ruimingde
//      All rights reserved
//      
//      filename :ClassLibrary.Helper.EmailHelper_2
//      description:
//
//      created by ֣ at 09/24/2008 12:45:22
//=====================================================================
using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Net.Mail;

using BookShopOnline.WebConfig;

namespace BookShopOnline.Utility
{
    public class EmailHelper
    {
        private SmtpClient  smtpClient;

        public EmailHelper(SmtpServer smtpServer)
        {

            SmtpClient smtp = new SmtpClient(smtpServer.ServerAddress,smtpServer.Port);
            smtp.Credentials = new NetworkCredential(smtpServer.UserName, smtpServer.UserPwd);
            smtp.EnableSsl = smtpServer.EnableSsl;
            smtpClient = smtp;
        }

        public void SendEmail(EmailMsg emailMsg)
        {
            MailMessage mailMsg = new MailMessage();

            //ʼַ
            mailMsg.From = new MailAddress(emailMsg.FromEmail, emailMsg.FromName);
            mailMsg.To.Add(new MailAddress(emailMsg.ToEmail, emailMsg.ToName));

            //ʼʵ
            mailMsg.Subject = emailMsg.Subject;
            mailMsg.Body = emailMsg.Body;
            mailMsg.BodyEncoding = emailMsg.BodyEncoding;
            mailMsg.IsBodyHtml = emailMsg.IsBodyHtml;

            smtpClient.Send(mailMsg);
        }

        /// <summary>
        /// ȡĬϵSmtpãWeb.Configļã
        /// </summary>
        public  static SmtpServer GetDefaultSmtpServer()
        {
            SmtpServer smtpServer = new SmtpServer();
            smtpServer.EnableSsl = Config.SmtpEnableSsl;
            smtpServer.FromEmail = Config.SmtpFromEmail;
            smtpServer.FromName = Config.SmtpFromName;
            smtpServer.Port = Config.SmtpPort;
            smtpServer.ServerAddress = Config.SmtpServerAddress;
            smtpServer.UserName = Config.SmtpUserName;
            smtpServer.UserPwd = Config.SmtpUserPwd;

            return smtpServer;
        }
    }
}
