using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using BookShopOnline.Model;

namespace BookShopOnline.Utility
{
    public class WebTool
    {
        #region ȡCartGuid
        public static string GetCartGuid()
        {
            if (HttpContext.Current.Request.Cookies["BookShopOnline"] != null)
            {
                return HttpContext.Current.Request.Cookies["BookShopOnline"]["CartGuid"].ToString();
            }
            else
            {
                Guid guid = new Guid();
                HttpCookie cookie = new HttpCookie("BookShopOnline");
                cookie.Values.Add("CartGuid", guid.ToString());
                cookie.Expires = DateTime.Now.AddDays(30);
                HttpContext.Current.Response.AppendCookie(cookie);
                return guid.ToString();
            }
        }
        #endregion

        #region  ؼtextбʾ,رʾtext
        public static string SetKeyWordInText(string text, string keyWord)
        {

            if (string.IsNullOrEmpty(keyWord))
                return text;

            string textLower = text.ToLower();
            int indexKeyWord = textLower.IndexOf(keyWord.ToLower());

            if (indexKeyWord >= 0)
            {
                string tempStr = text.Remove(indexKeyWord, keyWord.Length);
                string newKeyWord = string.Format("<span style='color:red;'>{0}</span>", keyWord);
                string newText = tempStr.Insert(indexKeyWord, newKeyWord);

                return newText;
            }
            else
            {

                return text;
            }
        }
        #endregion
    }
}
