﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Bll;
using BookShopOnline.Model;

public partial class PayResult:Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        UserState.CheckUserLogin();

        User userLogined = UserState.GetUserLogined();
        string orderID = PageHelper.GetUrlParmValue(UrlParmName.OrderID);

        if (string.IsNullOrEmpty(orderID))
            return;

        /*初始化定义参数*/

        //商户编号，请把您的商户编号替换掉这里的0值。
        String reg_userid = ConfigurationManager.AppSettings["reg_userid"];

        //商户密钥，请把您的商户密钥替换掉这里的空值。
        String reg_key = ConfigurationManager.AppSettings["reg_key"];

        //您可以充分利用以下反馈信息并添加到您自己的数据库中。
        String v_orderid = Request["v_orderid"];
        String v_orderdate = Request["v_orderdate"];
        String v_price = Request["v_price"];
        String v_billno = Request["v_billno"];
        String v_custom1 = Request["v_custom1"];
        String v_custom2 = Request["v_custom2"];
        String v_mobileno = Request["v_mobileno"];
        String v_servicename = Request["v_servicename"]; Response.Write("v_servicename:" + v_servicename);
        String v_payvia = Request["v_payvia"];
        String v_payviastr = Request["v_payviastr"];
        String v_md5 = Request["v_md5"];
        String v_pstatus = Request["v_pstatus"];
        String v_pstring = Request["v_pstring"];
        String v_paymode = Request["v_paymode"];

        if (v_orderid != null && v_pstatus.Equals("1"))
        {
            //-----------重新计算md5的值，验证返回的数字签名是否正确------------------------------------------------
            String md5text = v_orderid + v_billno + v_custom1 + v_custom2 + v_price + v_payvia + reg_userid + v_pstatus + reg_key + v_paymode;		//为正确数值串拼凑顺序
            string digestString = FormsAuthentication.HashPasswordForStoringInConfigFile(md5text, "MD5");  //计算MD5的值
            if (v_md5 != null && v_md5.Equals(digestString))
            {
               lblPayResult.Text="支付成功";

               decimal payPrice =(decimal)(Convert.ToUInt64(v_price) / 100.0);
               lblPayPrice.Text = WebTool.FormatMoney(payPrice);

               OrdersBll ordersBll = new OrdersBll();
               ordersBll.PayForOrders(userLogined.UserID, v_billno, payPrice);

                /*
                    建议在此对定单号和支付金额进行验证以防止用户刷新返回页面多次获得服务。
                    下面请放入定单成功后实时开通服务的代码或页面代码。
                */

            }
            else
            {
                lblPayResult.Text = "支付失败！签名验证错误！";
            }
        }
        else
        {
            lblPayResult.Text = "支付失败！无效的参数！";
        }

        if (!IsPostBack)
        {
            if (string.IsNullOrEmpty(orderID))
            {
                Response.Write("传递参数OrderID错误！");
                return;
            }
            HyperLink1.NavigateUrl += "?OrderID=" + orderID;
        }
    }
}
