﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Model;
using BookShopOnline.Utility;
using BookShopOnline.Bll;

public partial class UserCenter_AddOrder:Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        UserState.CheckUserLogin();

        if (!IsPostBack)
        {
            InvokeAddOrder1();
        }
    }

    private void InvokeAddOrder1()
    {
        AddOrder1._btnModifyOrders.Enabled = false;
        AddOrder1._btnModifyOrders.Visible = false;

        User userLogined = UserState.GetUserLogined();

        AddOrder1._txtReceiverName.Text = userLogined.RealName;
        AddOrder1._txtReceiverAddress.Text = userLogined.Address;
        AddOrder1._txtReceiverPostalCode.Text = userLogined.PostalCode;
        AddOrder1._txtReceiverPhone.Text = userLogined.Phone;
    }

    protected void AddOrdersClick(object sender, EventArgs e)
    {
        User userLogined = UserState.GetUserLogined();

        Orders orders = new Orders();
        orders.UserID = userLogined.UserID;//
        //收货人信息
        orders.ReceiverName = AddOrder1._txtReceiverName.Text;
        orders.ReceiverAddress = AddOrder1._txtReceiverAddress.Text;
        orders.ReceiverPhone = AddOrder1._txtReceiverPhone.Text;
        orders.ReceiverPostalCode = AddOrder1._txtReceiverPostalCode.Text;
        //付款方式
        orders.PayTypeID =Convert.ToInt32(AddOrder1._rblPayType.SelectedValue);
        //收货方式
        orders.PortTypeID =Convert.ToInt32( AddOrder1._rblPortType.SelectedValue);

        ShoppingCartBll shoppingCartBll = new ShoppingCartBll();
        DataSet shoppingCartList = shoppingCartBll.SelectShoppingCartByCartGuid(WebTool.GetCartGuid());

        OrdersBll ordersBll = new OrdersBll();
        string orderID = ordersBll.InsertOrders(orders, shoppingCartList);

        if (string.IsNullOrEmpty(orderID))
        {
            AddOrder1._lblMsg.Text = "生成订单失败！请检查输入并重试。";
        }
        else
        {
            //发送订单邮件
            string toEmail = userLogined.Email;
            EmailOrder emailOrder = new EmailOrder(toEmail, orderID);
            emailOrder.SendEmail();

            Response.Redirect("~/UserCenter/ShowOrder.aspx?OrderID=" + orderID+"&ToEmail="+toEmail);
        }
    }
}
