﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Bll;
using BookShopOnline.Model;

public partial class AddToFavorites:Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        UserState.CheckUserLogin();
        int bookID = 0;
        if (int.TryParse(PageHelper.GetUrlParmValue(UrlParmName.BookID), out bookID))
        {
            InsertFavorites(bookID);
        }
    }

    private void InsertFavorites(int bookID)
    {
        User userLogined = UserState.GetUserLogined();
       
        Favorites favorites = new Favorites();
        favorites.BookID = bookID;
        favorites.UserID = userLogined.UserID;

        new FavoritesBll().InsertFavorites(favorites);

        Response.Redirect("~/UserCenter/Favorites.aspx");
    }
}
