﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Bll;
using BookShopOnline.Model;

public partial class Admin_AddBook : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            SetAddBook1();
        }
    }

    private void SetAddBook1()
    {
        AddBook1._btnModify.Visible = false;
    }

    #region 添加图书
    protected void AddClick(object sender, EventArgs e)
    {
       //验证输入
        string msg="";
        if (!AddBook1.InputValid(out msg))
        {
            AddBook1._lblMessage.Text = "输入错误！" + msg;
            return;
        }

        Book book = new Book();
        //图片，书名，类别ID，介绍，原价，售价，数量，库存,作者，出版社，出版时间，ISBN
        book.ImgID =0;
        book.BookName = AddBook1._txtBookName.Text;
        book.BookTypeID = Convert.ToInt32(AddBook1._BookTypeIDSelected);
        book.Description = AddBook1._Description.Text;
        book.OriginalPrice = Convert.ToDecimal(AddBook1._txtOriginalPrice.Text);
        book.Quatity = Convert.ToInt32(AddBook1._txtQuatity.Text);
        book.SellPrice = Convert.ToDecimal(AddBook1._txtSellPrice.Text);
        book.Storage = Convert.ToInt32(AddBook1._txtStorage.Text);
        book.Author = AddBook1._txtAuthor.Text;
        book.Press = AddBook1._txtPress.Text;
        book.DatePressed =AddBook1._txtDatePressed.Text;
        book.ISBN = AddBook1._txtISBN.Text;

        if(!string.IsNullOrEmpty(AddBook1._hidImgID.Value))
        {
            book.ImgID=Convert.ToInt32(AddBook1._hidImgID.Value);
        }

        BookBll bookBll = new BookBll();
        int result=bookBll.InsertBook(book);
        if (result > 0)
        {
            AddBook1._lblMessage.Text = "添加成功！";
        }
        else
        {
            AddBook1._lblMessage.Text = "添加失败！";
        }
    }
    #endregion

    #region 上传图片
    protected void UpLoadClick(object sender, EventArgs e)
    {
        if (!AddBook1._fileBookImg.HasFile)
        {
            return;
        }

        int imgID = WebTool.UpLoadBookImg(AddBook1._fileBookImg, AddBook1._imgBookImg);

        if (imgID > 0)
        {
            AddBook1._lblUploadImgMsg.Text= "上传成功!";
            AddBook1._hidImgID.Value = imgID.ToString();
        }
        else
        {
            AddBook1._lblUploadImgMsg.Text= "上传失败！请重试。";
        }
    }
    #endregion
}
