﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
//该源码首发自www.51aspx.com(５１aｓｐｘ．ｃｏｍ)

using BookShopOnline.Bll;
using BookShopOnline.Model;

public partial class Admin_AdminLogin:Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            UserLogin1.LblTitle.Text = "管理员用户登录";
            UserLogin1._UserName.Focus();
        }
    }

    private string ReturnUrl
    {
        get
        {
            if (Request.QueryString["ReturnUrl"] == null)
                return null;

            return Request.QueryString["ReturnUrl"].ToString();
        }
    }

    protected void SubmitClick(object sender, EventArgs e)
    {
        User adminLogined= new UserBll().CheckUserLogin(UserLogin1._UserName.Text, UserLogin1._UserPwd.Text, Role.AdminUser);

        if (adminLogined == null)
        {
            AdminState.SetUserLogined(adminLogined);
            FormsAuthentication.RedirectFromLoginPage(UserLogin1._UserName.Text, false);
            
            if (string.IsNullOrEmpty(ReturnUrl))
                Response.Redirect("OrderList.aspx?TypeID=1");
            else
                Response.Redirect(ReturnUrl);
        }
        else
        {
            UserLogin1._Msg.Text = "用户名或密码错误！请重试。";
            UserLogin1._UserPwd.Focus();
        }
    }
}
