﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Bll;
using BookShopOnline.Model;

public partial class Admin_CheckOrder:Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            string orderID = PageHelper.GetUrlParmValue(UrlParmName.OrderID);

            if (!string.IsNullOrEmpty(orderID))
            {
                OrderDetail1.BindOrderDetail(orderID);
                OrderInfo1.BindOrderInfo(orderID);
                BindOrderStatic(orderID);
                BindOrderStaticTip(OrderInfo1.TipID);
            }
        }
    }

    //绑定订单状态
    private void BindOrderStatic(string orderID)
    {
        cblOrderStatic.DataTextField = "StaticName";
        cblOrderStatic.DataValueField = "StaticID";

        DataSet ds = new OrdersBll().SelectOrderStaticByOrderID(orderID);
        cblOrderStatic.DataSource = ds;
        cblOrderStatic.DataBind();

        if(ds!=null&&ds.Tables[0].Rows.Count>0)
        for (int i=0;i<ds.Tables[0].Rows.Count;i++)
        {
            cblOrderStatic.Items[i].Selected=Convert.ToBoolean(ds.Tables[0].Rows[i]["YesOrNo"]);
        }
    }

    //绑定订单状态提示
    private void BindOrderStaticTip(int tipID)
    {
        rblOrderStaticTip.DataTextField = "TipName";
        rblOrderStaticTip.DataValueField = "TipID";

        DataSet ds = new OrdersBll().SelectOrderStaticTip();
        rblOrderStaticTip.DataSource = ds;
        rblOrderStaticTip.DataBind();

        if (ds != null && ds.Tables[0].Rows.Count > 0)
        for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
        {
            if (rblOrderStaticTip.Items[i].Value == tipID.ToString())
            {
                rblOrderStaticTip.Items[i].Selected = true;
                break;
            }
        }
    }

    //保存
    protected void btnSave_Click(object sender, EventArgs e)
    {
        string orderID = PageHelper.GetUrlParmValue(UrlParmName.OrderID);

        if (string.IsNullOrEmpty(orderID))
            return;

        IList<Order_OrderStatic> order_OrderStaticList=new List<Order_OrderStatic>();
        for(int i=0;i<cblOrderStatic.Items.Count;i++)
        {
            Order_OrderStatic order_OrderStatic=new Order_OrderStatic();
            order_OrderStatic.StaticID=Convert.ToInt32(cblOrderStatic.Items[i].Value);
            order_OrderStatic.YesOrNo=cblOrderStatic.Items[i].Selected;

            order_OrderStaticList.Add(order_OrderStatic);
        }

        int tipID=Convert.ToInt32( rblOrderStaticTip.SelectedValue);

        bool result = new OrdersBll().UpdateOrderStaicAndTip(orderID, order_OrderStaticList, tipID);

        if (result == true)
        {
            lblMsg.Text = "保存成功！";
            OrderInfo1.BindOrderInfo(orderID);
        }
        else
        {
            lblMsg.Text = "保存失败！";
        }
    }
}
