﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Bll;
using BookShopOnline.Model;

public partial class Admin_OrderList : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            BindOrderList(OrderTypeRequest);
            OrderTypeSelected = OrderTypeRequest;
        }
    }

    #region 成员属性
    private OrderType OrderTypeRequest
    {
        get
        {
            if (Request.QueryString["TypeID"] == null)
                return OrderType.All;

            return GetOrderType( Request.QueryString["TypeID"].ToString());
        }
    }

    private OrderType OrderTypeSelected
    {
        get
        {
            if (ViewState["OrderType"] == null)
                return OrderType.All;

            return (OrderType)ViewState["OrderType"];
        }
        set
        {
            ViewState["OrderType"] = value;
        }
    }
    #endregion

    #region 绑定数据
    private void BindOrderList(OrderType orderType)
    {
        OrdersBll ordersBll = new OrdersBll();
        OrderList1.OrderListDS = ordersBll.SelectOrdersByOrderType(orderType);
        OrderList1.BindOrderList();
    }

    protected void BindOrderList(object sender, CommandEventArgs e)
    {
        string commArg = e.CommandArgument.ToString();
        OrderType orderType = GetOrderType(commArg);

        OrderTypeSelected = orderType;

        BindOrderList(orderType);
    }
    #endregion

    #region 分页处理
    protected void PageIndexChanging(object sender, EventArgs e)
    {
        BindOrderList(OrderTypeSelected);
    }
    #endregion

    #region 设置选中链接的样式
    private void SetLinkButtonSelected(LinkButton lbtn)
    {
        lbtnAll.Style.Value = "";
        lbtnHasCancel.Style.Value = "";
        lbtnHasPayed.Style.Value = "";
        lbtnHasPorted.Style.Value = "";
        lbtnNoConfirm.Style.Value = "";
        lbtnNoPayed.Style.Value = "";
        lbtnNoPorted.Style.Value = "";
        lbtnToday.Style.Value = "";

        lbtn.Style.Value = "font-size: 13px; color: #ff2828; text-decoration: underline;";
    }
    #endregion

    #region 辅助方法
    private OrderType GetOrderType(string typeID)
    {
        switch (typeID)
        {
            case "1"://今日订单
                {
                    SetLinkButtonSelected(lbtnToday);
                    return OrderType.Today;
                }
            case "2"://未确认
                {
                    SetLinkButtonSelected(lbtnNoConfirm);
                    return OrderType.NoConfirm;
                }
            case "3"://未付款
                {
                    SetLinkButtonSelected(lbtnNoPayed);
                    return OrderType.NoPayed;
                }
            case "4"://未发货
                {
                    SetLinkButtonSelected(lbtnNoPorted);
                    return OrderType.NoPorted;
                }
            case "5"://已付款
                {
                    SetLinkButtonSelected(lbtnHasPayed);
                    return OrderType.HasPayed;
                }
            case "6"://已发货
                {
                    SetLinkButtonSelected(lbtnHasPorted);
                    return OrderType.HasPorted;
                }
            case "7"://已取消
                {
                    SetLinkButtonSelected(lbtnHasCancel);
                    return OrderType.HasCancel;
                }
            default://所有订单
                {
                    SetLinkButtonSelected(lbtnAll);
                    return OrderType.All;
                }
        }
    }
    #endregion
}
