﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Bll;

public partial class Admin_SearchOrder : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }

    #region 属性
    private string OrderID//订单号
    {
        get
        {
            return ViewState["OrderID"].ToString();
        }
        set
        {
            ViewState["OrderID"] = value;
        }
    }

    private string OrderDate//订单时间
    {
        get
        {
            return ViewState["OrderDate"].ToString();
        }
        set
        {
            ViewState["OrderDate"]=value;
        }
    }
    #endregion

    #region 绑定数据
    private void BindOrderList()
    {
        OrderList1.OrderListDS = new OrdersBll().SelectOrdersBySearch(OrderID, OrderDate);
        OrderList1.BindOrderList();
    }
    #endregion

    #region 搜索
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        OrderID = txtOrderID.Text;
        OrderDate = txtOrderDate.Text;

        BindOrderList();
    }
    #endregion

    #region 分页
    protected void OnPageIndexChanging(object sender, EventArgs e)
    {
        BindOrderList();
    }
    #endregion
}
