﻿//====================================================================
//      Copyright(C) 2008-2009 ruimingde
//      All rights reserved
//      
//      filename :AdminState
//      description:
//
//      created by 郑瑞明 at 10/12/2008 20:33:41
//=====================================================================
using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Model;

/// <summary>
/// AdminState 的摘要说明
/// </summary>
public class AdminState
{
    public static User GetUserLogined()
    {
        object userLogined = PageHelper.GetSession(SessionName.AdminLogined);//AdminLogined管理员

        if (userLogined == null)
            return null;

        return (User)userLogined;
    }

    public static void SetUserLogined(User userLogined)
    {
        PageHelper.SetSession(SessionName.UserLogined, userLogined);
    }

    public static void CheckUserLogin()
    {
        if (GetUserLogined() == null)
        {
            HttpContext.Current.Response.Redirect("~/Admin/AdminLogin.aspx");
        }
    }

    public static void Logout()
    {
        if (GetUserLogined() != null)
        {

            PageHelper.SetSession(SessionName.AdminLogined, null);
            HttpContext.Current.Session.Abandon();
           
        }
        HttpContext.Current.Response.Redirect("~/Admin/AdminLogin.aspx");
    }
}
