﻿using System;
using System.Data;
using System.Collections;
using System.Collections.Generic;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Model;
using BookShopOnline.Bll;

/// <summary>
/// BookTypeTreeView 的摘要说明
/// </summary>
public class BookTypeTreeView
{
    private TreeView TreeView1;
    private static ArrayList TreeView1Cached = new ArrayList();

    public BookTypeTreeView(TreeView treeView)
    {
        TreeView1 = treeView;
    }



    #region 生成树形菜单

    #region 共有方法
    public void CreateTree()
    {
        if (TreeView1Cached == null || TreeView1Cached.Count==0)
            CreateTreeFromDB();
        else
            CreateTreeFromCache();
    }
    #endregion

    #region 私有方法
    //创建树形菜单(从数据库）
    private void CreateTreeFromDB()
    {
        //删除缓存
        if (TreeView1Cached != null)
            TreeView1Cached.Clear();

        BookTypeBll bookTypeBll = new BookTypeBll();
        IList<BookType> bookTypeList = bookTypeBll.SelectRootBookType();

        foreach (BookType bookType in bookTypeList)
        {
            TreeNode rootNode = new TreeNode();
            rootNode.Value = bookType.BookTypeID.ToString();
            rootNode.Text = bookType.BookTypeName;
            rootNode.ToolTip = bookType.BookTypeName;
            rootNode.NavigateUrl = string.Format("../BookList.aspx?BookTypeID={0}&BookTypeName={1}",bookType.BookTypeID,Uri.EscapeDataString(bookType.BookTypeName));
            rootNode.Target = "_blank";
            rootNode.Expanded = false;

            CreateNextNode(rootNode, bookType.BookTypeID);

            TreeView1.Nodes.Add(rootNode);
            TreeView1Cached.Add(rootNode);//更新缓存
        }

        TreeView1.DataBind();
    }

    //从缓存中生成树形菜单
    private void CreateTreeFromCache()
    {
        TreeView1.Nodes.Clear();

        for (int i = 0; i <TreeView1Cached.Count; i++)
        {
            TreeNode treeNode = (TreeNode)TreeView1Cached[i];
            TreeView1.Nodes.Add(treeNode);
        }

        TreeView1.DataBind();
    }

    //创建下一个节点
    private void CreateNextNode(TreeNode parentNode, int parentID)
    {
        BookTypeBll bookTypeBll = new BookTypeBll();
        IList<BookType> bookTypeList = bookTypeBll.SelectSubBooType(parentID);

        foreach (BookType bookType in bookTypeList)
        {
            TreeNode nextNode = new TreeNode();
            nextNode.Value = bookType.BookTypeID.ToString();
            nextNode.Text = bookType.BookTypeName;
            nextNode.ToolTip = bookType.BookTypeName;
            nextNode.NavigateUrl = string.Format("../BookList.aspx?BookTypeID={0}&BookTypeName={1}", bookType.BookTypeID, Uri.EscapeDataString(bookType.BookTypeName));
            nextNode.Target = "_blank";
            nextNode.Expanded = false;

            parentNode.ChildNodes.Add(nextNode);
            CreateNextNode(nextNode, bookType.BookTypeID);
        }
    }
    #endregion
    #endregion
}
