﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.Threading;

using BookShopOnline.Model;
using BookShopOnline.Bll;
using BookShopOnline.Utility;

/// <summary>
/// EmailOrderContent 的摘要说明
/// </summary>
public class EmailOrder
{
    private string ToEmail;
    private string OrderID;
    private DataSet OrderDetail;
    private DataRow Order;
    private string UrlAuthority;

    public EmailOrder(string toEmail,string orderID)
    {
        ToEmail = toEmail;
        OrderID = orderID;
        UrlAuthority = HttpContext.Current.Request.Url.Authority;
    }

    private string EmailOrderSubject
    {
        get { return "网络书店订单:" + OrderID; }
    }

    private string EmailOrderContent
    {
        get
        {

            string urlShowBookDetail = "http://" + UrlAuthority + "/ShowBookDetail.aspx";
            string urlShowOrder = "http://" + UrlAuthority + "/UserCenter/ShowOrder.aspx";

            StringBuilder content = new StringBuilder();
            content.AppendLine("订单清单");
            content.Append("<table border='1' style='border-collapse:collapse;'>");
            content.Append("<tr>");
            content.Append("<th scope='col'>图书名称</th>");
            content.Append("<th scope='col'>原价</th>");
            content.Append("<th scope='col'>售价</th>");
            content.Append("<th scope='col'>数量</th>");
            content.Append("<th scope='col'>总售价</th>");
            content.Append("</tr>");
            foreach (DataRow dr in OrderDetail.Tables[0].Rows)
            {
                content.Append("<tr>");
                content.Append(string.Format("<td><a href='{0}?BookID={1}' title='{2}'>{3}</a></td>", urlShowBookDetail, dr["BookID"], dr["BookName"], dr["BookName"].ToString()));
                content.Append(string.Format("<td>{0}</td>",WebTool.FormatMoney(dr["OriginalPrice"])));
                content.Append(string.Format("<td>{0}</td>", WebTool.FormatMoney(dr["SellPrice"])));
                content.Append(string.Format("<td align='center'>{0}</td>", dr["Quatity"]));
                content.Append(string.Format("<td>{0}</td>", WebTool.FormatMoney(dr["TotalSellPrice"])));
                content.Append("</tr>");
            }
            content.AppendLine("</table>");
            content.Append("<br/>");

            content.AppendLine("订单信息");
            content.Append("<table cellspacing='0' border='0'  style='border-collapse:collapse;'>");
            content.Append("<tr>");
            content.Append("<td colspan='2'>");
            content.Append(string.Format("订单号：{0}<br />", Order["OrderID"]));
            content.Append(string.Format("下单时间：{0}<br />", Order["OrderDate"]));
            content.Append(string.Format("订单状态：{0}({1})<br />", Order["TipName"], Order["UpdateStaticDate"]));
            content.Append("<br />");
            content.Append("收货人信息<br />");
            content.Append(string.Format("姓名：{0}<br />", Order["ReceiverName"]));
            content.Append(string.Format("地址：{0}<br />", Order["ReceiverAddress"]));
            content.Append(string.Format("邮编：{0}<br />", Order["ReceiverPostalCode"]));
            content.Append(string.Format("电话：{0}<br />", Order["ReceiverPhone"]));
            content.Append("<br />");
            content.Append(string.Format("收货方式：{0}", Order["PortTypeName"]));
            content.Append(string.Format("运费：{0}<br />", WebTool.FormatMoney(Order["PortPrice"])));
            content.Append("<br />");
            content.Append(string.Format("付款方式：{0}<br/>", Order["PayTypeName"]));
            content.Append("<br />");
            content.Append("费用信息<br />");
            content.Append(string.Format("书本总价格：{0}<br />", WebTool.FormatMoney(Order["TotalBookPrice"])));
            content.Append(string.Format("运费：{0}<br />", WebTool.FormatMoney(Order["PortPrice"])));
            content.Append(string.Format("总费用：{0}<br />", WebTool.FormatMoney(Order["SumPrice"])));
            content.Append(string.Format("已付费用：{0}<br />", WebTool.FormatMoney(Order["HasPayedPrice"])));
            content.Append(string.Format("未付费用：{0}", WebTool.FormatMoney(Order["HasNotPayedPrice"])));
            content.Append("</td>");
            content.Append("</tr>");
            content.Append("</table>");

            content.Append("<br/>");
            content.Append(string.Format("<a href='{0}?OrderID={1}'>查看订单</a>", urlShowOrder, OrderID));
            return content.ToString();
        }
    }

    private void StartSendEmail()
    {
        Order=new OrdersBll().SelectOrdersByOrderID(OrderID).Tables[0].Rows[0];

        OrderDetail = new OrderDetailBll().SelectOrderDetailByOrderID(OrderID);

        Email email = new Email(ToEmail, EmailOrderSubject, EmailOrderContent);
        email.Send();

    }

    public void SendEmail()
    {
        ThreadStart threadStartSendEmail = new ThreadStart(StartSendEmail);
        Thread threadSendEmail = new Thread(threadStartSendEmail);
        threadSendEmail.Start();
    }
}
