﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Model;
using BookShopOnline.Utility;

/// <summary>
/// BasePage 的摘要说明
/// </summary>
public class PageHelper
{

    public static string GetUrlParmValue(UrlParmName urlParmName)
    {
        return HttpContext.Current.Request.QueryString[urlParmName.ToString()];
           
    }

    public static object GetSession(SessionName sessionName)
    {
        return HttpContext.Current.Session[sessionName.ToString()];
    }

    public static void SetSession(SessionName sessionName,object value)
    {
        HttpContext.Current.Session[sessionName.ToString()] = value;
    }

    /// <summary>
    /// 获取上一次请求的Url
    /// </summary>
    public static string GetFromUrl()
    {
        if (HttpContext.Current.Request.UrlReferrer == null || HttpContext.Current.Request.UrlReferrer == HttpContext.Current.Request.Url)
            return null;

        return HttpContext.Current.Request.UrlReferrer.ToString();
    }

    /// <summary>
    /// 获取原始Url
    /// </summary>
    public static string GetRawUrl()
    {
       return HttpContext.Current.Request.RawUrl;
    }

    //public string UrlAuthority
    //{
    //    get { return HttpContext.Current.Request.Url.Authority; }
    //}

    ////例如：/web
    //public string WebRootPath
    //{
    //    get { return HttpContext.Current.Request.ApplicationPath; }
    //}

 
}
