﻿//====================================================================
//      Copyright(C) 2008-2009 ruimingde
//      All rights reserved
//      
//      filename :UserState
//      description:
//
//      created by 郑瑞明 at 10/12/2008 18:55:43
//=====================================================================
using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Model;

/// <summary>
/// UserState 的摘要说明
/// </summary>
public class UserState
{

    public static User GetUserLogined()
    {
        object userLogined = PageHelper.GetSession(SessionName.UserLogined);

        if (userLogined == null)
            return null;

        return (User)userLogined;
    }

    public static void SetUserLogined(User userLogined)
    {
        PageHelper.SetSession(SessionName.UserLogined, userLogined);
    }

    public static void CheckUserLogin()
    {
        if (GetUserLogined() == null)
        {
            string rawUrl = PageHelper.GetRawUrl();

            HttpContext.Current.Response.Redirect("~/Login.aspx?BackUrl="+rawUrl);
        }
    }

    public static void Logout()
    {
        if (GetUserLogined() == null)
        {
            HttpContext.Current.Response.Redirect("~/Logout.aspx");
        }
        else
        {
            PageHelper.SetSession(SessionName.UserLogined, null);
            HttpContext.Current.Session.Abandon();

            HttpContext.Current.Response.Redirect("~/Default.aspx");
        }
    }
}
