﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Bll;
using BookShopOnline.Model;
using BookShopOnline.Utility;
using BookShopOnline.WebConfig;

/// <summary>
/// WebTool 的摘要说明
/// </summary>
public class WebTool
{

    #region 上传图片
    public static int UpLoadBookImg(FileUpload fileUpload,Image img)
    {
        string oldFileName = fileUpload.FileName;
        string fileType = oldFileName.Substring(oldFileName.IndexOf('.'));
        DateTime now = DateTime.Now;
        string newFileName = now.Year.ToString() + now.Month + now.Day + now.Hour + now.Minute + now.Second + now.Millisecond + fileType;
        string imgPath = "BookImg/" + newFileName;
        string serverRootPath =HttpContext.Current.Server.MapPath("../BookImg/");

        BookImg bookImg = new BookImg();
        bookImg.ImgPath =imgPath;

        BookBll bookBll = new BookBll();
        int imgID = 0;
        try
        {
            imgID = bookBll.InsertBookImg(bookImg);
        }
        catch
        {
            return imgID;
        }

        try
        {
            
            fileUpload.PostedFile.SaveAs(serverRootPath + newFileName);
            img.ImageUrl ="~/"+ imgPath;
        }
        catch
        {
            //删除数据库中的图片记录
            bookBll.DeleteBookImg(imgID);
            imgID = 0;
        }

        return imgID;
    }
    #endregion

    #region 截取字符串，多出的部分用"..."替代
    public static string GetSubString(string str, int num)
    {
        string subStr = "";
        if (!string.IsNullOrEmpty(str))
        {
            if (str.Length > num)
            {
                subStr = str.Substring(0, num);
                subStr += "...";
            }
            else
            {
                subStr = str;
            }
        }

        return subStr;
    }
    #endregion

    #region 获取CartGuid
    public static string GetCartGuid()
    {
        return BookShopOnline.Utility.WebTool.GetCartGuid();
    }
    #endregion

    #region 转换为人民币货币格式
    public static string FormatMoney(object money)
    {
        return string.Format("{0:c}", money);
    }
    #endregion

    #region 弹出提示
    public static void JscriptAlert(string msg)
    {
        string jscriptAlert =string.Format("<script> alert('{0}')</script>",msg);

        HttpContext.Current.Response.Write(jscriptAlert);
    }
    #endregion

    #region 打开新的页面
    public static void OpenNewPage(string url)
    {
        string str = string.Format("<script>window.open('{0}','_blank')</script>", url);

        HttpContext.Current.Response.Write(str);
    }
    #endregion

    #region 截取图书名称
    public static string GetSubString(string str)
    {
       return GetSubString(str, Config.BookNameSubLength);
    }
    #endregion

    #region 将字符串日期转换为年日月格式：2008-9-9
    public static string GetShortDate(string dateTime)
    {
        DateTime dt;
        if (DateTime.TryParse(dateTime, out dt))
            return dt.ToShortDateString();
        else
            return "";
    }
    #endregion

    #region  将关键字在text中标示,返回标示后的text
    public static string SetKeyWordInText(string text, string keyWord)
    {
        return BookShopOnline.Utility.WebTool.SetKeyWordInText(text, keyWord);
    }
    #endregion

    #region  记录浏览图书历史的图书ID
    const string cookieName = "BooksVisited";
    const string cookieKeyName = "BookIDList";
    public static void SaveBookIDInCookies(string bookID)
    {
        if (string.IsNullOrEmpty(bookID))
            return;

        string oldBookIDList = GetBookIDInCookies();
        if (string.IsNullOrEmpty(oldBookIDList))
        {
            HttpCookie cookie = new HttpCookie(cookieName);
            cookie.Expires = DateTime.Now.AddDays(7);
            cookie.Values.Add(cookieKeyName, bookID);

            HttpContext.Current.Response.Cookies.Add(cookie);
        }
        else
        {
            HttpCookie cookie = new HttpCookie(cookieName);
            cookie.Expires = DateTime.Now.AddDays(7);
            string newBookIDList = "";
            int indexBookID = oldBookIDList.IndexOf(bookID);
            if (indexBookID== 0)//已存在(在第一个位置）
            {
                newBookIDList = oldBookIDList;   
            }
            else if (indexBookID > 0)//已存在(不在第一个位置）
            {
                newBookIDList = bookID + "," + oldBookIDList.Remove(indexBookID - 1, bookID.Length + 1);

            }
            else//不存在
            {
                newBookIDList = bookID + "," + oldBookIDList;
            }

            cookie.Values.Add(cookieKeyName, newBookIDList);

            HttpContext.Current.Response.Cookies.Add(cookie);

        }
    }

    public static string GetBookIDInCookies()
    {
        if (HttpContext.Current.Request.Cookies[cookieName] == null)
        {
            return null;
        }

        return HttpContext.Current.Request.Cookies[cookieName][cookieKeyName];
    }

    public static void ClearBookIDInCookies()
    {
        if (HttpContext.Current.Request.Cookies[cookieName] != null)
        {
            HttpCookie cookie = new HttpCookie(cookieName);
            cookie.Expires = DateTime.Now.AddDays(-1);
            HttpContext.Current.Response.Cookies.Add(cookie);

            HttpContext.Current.Request.Cookies.Remove(cookieName);
        }

    }
    #endregion
}

