﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Bll;
using BookShopOnline.Model;

public partial class BookList : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (string.IsNullOrEmpty(BookTypeID))
            return;
        if (!IsPostBack)
        {
            BookList1.PageIndex = 1;
            BindBookList(BookTypeID,BookOrderByFields.DateAdded);
            BookList1.LblSearchCondition.Text = "搜索类别：" + BookTypeName;
        }
    }

    private string BookTypeID
    {
        get
        {
            if(BookTypeTreeNavigationExpanded1._SelectedNode==null)
            {
                if (Request.QueryString["BookTypeID"] == null)
                   return null;

                return Request.QueryString["BookTypeID"].ToString();
            }
            else
            {
                return BookTypeTreeNavigationExpanded1._SelectedNode.Value;
            }
        }
    }

    private string BookTypeName
    {
        get
        {
            if (Request.QueryString["BookTypeName"] == null)
                return null;

            return Uri.UnescapeDataString( Request.QueryString["BookTypeName"].ToString());
        }
    }

    #region 绑定图书
    private void BindBookList(string bookTypeID,string orderField)
    {
        DataSet ds = null;

        BookBll bookBll = new BookBll();
        switch (BookList1.OrderByField)
        {
            case BookOrderByFields.DateAdded://上架时间
                {
                    ds = bookBll.SelectBookByBookTypeIDListByPageByDateAdded(bookTypeID, BookList1.PageIndex, BookList1.IsDesc, out BookList1.RecordCount);
                    break;
                }
            case BookOrderByFields.DatePressed://出版时间
                {
                    ds = bookBll.SelectBookByBookTypeIDListByPageByDatePressed(bookTypeID, BookList1.PageIndex, BookList1.IsDesc, out BookList1.RecordCount);
                    break;
                }
            case BookOrderByFields.SellOff://折扣
                {
                    ds = bookBll.SelectBookByBookTypeIDListByPageBySellOff(bookTypeID, BookList1.PageIndex, BookList1.IsDesc, out BookList1.RecordCount);
                    break;
                }
            case BookOrderByFields.SellPrice://售价
                {
                    ds = bookBll.SelectBookByBookTypeIDListByPageBySellPrice(bookTypeID, BookList1.PageIndex, BookList1.IsDesc, out BookList1.RecordCount);
                    break;
                }
            case BookOrderByFields.SoldCount://销售量
                {
                    ds = bookBll.SelectBookByBookTypeIDListByPageBySoldCount(bookTypeID, BookList1.PageIndex, BookList1.IsDesc, out BookList1.RecordCount);
                    break;
                }
            case BookOrderByFields.VisitedCount://人气
                {
                    ds = bookBll.SelectBookByBookTypeIDListByPageByVisitedCount(bookTypeID, BookList1.PageIndex, BookList1.IsDesc, out BookList1.RecordCount);
                    break;
                }
        }

        BookList1.BookListDs = ds;
        BookList1.BindBookList();
    }
    #endregion

    #region 导航节点改变
    protected void OnSelectedNodeChanged(object sender, EventArgs e)
    {
        BindBookList(BookTypeID,BookList1.OrderByField);

        BookList1.LblSearchCondition.Text = "搜索类别：" + BookTypeTreeNavigationExpanded1._SelectedNode.Text;
    }
    #endregion

    #region 分页
    protected void OnEventPageChanging(object sender, EventArgs e)
    {
        BindBookList(BookTypeID,BookList1.OrderByField);
    }
    #endregion

    #region 排序
    protected void OnEventOrderClick(object sender, EventArgs e)
    {
        BindBookList(BookTypeID, BookList1.OrderByField);
    }
    #endregion
}
