﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Bll;

public partial class BookListBySearch : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (KeyWord == null || SearchType == null)
                return;
            InitControl();
            BindBookList();
            
        }
    }

    #region KeyWord
    private string KeyWord
    {
        get
        {
            if (Request.QueryString["KeyWord"] == null)
                return null;

            return Uri.UnescapeDataString(Request.QueryString["KeyWord"].ToString());
        }
    }
    #endregion

    #region SearchType
    private string SearchType
    {
        get
        {
            if (Request.QueryString["SearchType"] == null)
                return null;

            return Request.QueryString["SearchType"].ToString();
        }
    }
    #endregion


    private void BindBookList()
    {
        BookList1.BookListDs = new BookBll().SelectBookBySearchByPage(KeyWord, SearchType,BookList1.PageIndex,BookList1.OrderByField,BookList1.IsDesc,out BookList1.RecordCount);
        BookList1.BindBookList();
    }

    private void InitControl()
    {
        Master.TxtKeyWord.Text = KeyWord;
        try
        {
            Master.RblSearchType.SelectedValue = SearchType;

        }
        catch { }
        BookList1.KeyWord = KeyWord;
        BookList1.LblSearchCondition.Text = "在<b>" + Master.RblSearchType.SelectedItem.Text + "</b>中搜索关键词：" + KeyWord;

        BookList1.DatalistBookList.RepeatColumns =2;
        BookList1.DatalistBookList.Width =Unit.Pixel(760);

    }


    protected void OnEventPageChanging(object sender, EventArgs e)
    {
        BindBookList();
    }

    protected void OnEventOrderClick(object sender, EventArgs e)
    {
        BindBookList();
    }
}
