﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using FreeTextBoxControls;

public partial class Controls_AddBook : System.Web.UI.UserControl
{
    public event EventHandler AddClick;
    public event EventHandler ModifyClick;
    public event EventHandler UpLoadClick;

    protected void Page_Load(object sender, EventArgs e)
    {

    }

    public TextBox _txtBookName
    {
        get { return txtBookName; }
        set { txtBookName = value; }
    }

    public TextBox _txtAuthor
    {
        get { return txtAuthor; }
        set { txtAuthor = value; }
    }

    public TextBox _txtPress
    {
        get { return txtPress; }
        set { txtPress = value; }
    }

    public TextBox _txtDatePressed
    {
        get { return txtDatePressed; }
        set { txtDatePressed = value; }
    }

    public TextBox _txtISBN
    {
        get { return txtISBN; }
        set { txtISBN = value; }
    }

    public TextBox _txtOriginalPrice
    {
        get { return txtOriginalPrice; }
        set { txtOriginalPrice = value; }
    }

    public TextBox _txtSellPrice
    {
        get { return txtSellPrice; }
        set { txtSellPrice = value; }
    }

    public TextBox _txtQuatity
    {
        get { return txtQuatity; }
        set { txtQuatity = value; }
    }

    public TextBox _txtStorage
    {
        get{ return txtStorage;}
        set { txtStorage = value; }
    }

    public FileUpload _fileBookImg
    {
        get { return fileBookImg; }
        set { fileBookImg = value; }
    }

    public Image _imgBookImg
    {
        get { return imgBookImg; }
        set { imgBookImg = value; }
    }

    public HiddenField _hidImgID
    {
        get { return hidImgID; }
        set { hidImgID = value; }
    }

    public string _BookTypeIDSelected
    {
        get 
        {
            if (BookTypeTreeForAdd1._SelectedNode == null)
                return null;

            return BookTypeTreeForAdd1._SelectedNode.Value; 
        }
    }

    public FreeTextBox _Description
    {
        get { return FreeTextBox1; }
        set { FreeTextBox1 = value; }
    }

    public Button _btnAdd
    {
        get { return btnAdd; }
        set { btnAdd = value; }
    }

    public Button _btnModify
    {
        get { return btnModify; }
        set { btnModify = value; }
    }

    public Label _lblMessage
    {
        get { return lblMessage; }
        set { lblMessage = value; }
    }

    public Label _lblUploadImgMsg
    {
        get { return lblUploadImgMsg; }
        set { lblUploadImgMsg = value; }
    }

    protected void SelectedNodeChanged(object sender, EventArgs e)
    {
        lblBookType.Text = BookTypeTreeForAdd1.GetNodeNamesSelected();
    }

    protected void btnAdd_Click(object sender, EventArgs e)
    {
        AddClick(this, e);
    }

    protected void btnModify_Click(object sender, EventArgs e)
    {
        ModifyClick(this, e);
    }

    protected void btnUpLoadBookImg_Click(object sender, EventArgs e)
    {
        UpLoadClick(this, e);
    }

    //验证输入
    public bool InputValid(out string msg)
    {
        msg = "";
        decimal originalPrice;
        if (!decimal.TryParse(txtOriginalPrice.Text, out originalPrice))
        {
            msg = "原价输入格式错误。";
            return false ;
        }

        decimal sellPrice;
        if (!decimal.TryParse(txtSellPrice.Text, out sellPrice))
        {
            msg = "售价输入格式错误。";
            return false ;
        }

        int quatity;
        if (!int.TryParse(txtQuatity.Text, out quatity))
        {
            msg = "数量输入格式错误。";
            return false ;
        }

        int storage;
        if (!int.TryParse(txtStorage.Text, out storage))
        {
            msg = "库存输入格式错误。";
            return false ;
        }

        if (string.IsNullOrEmpty(_BookTypeIDSelected))
        {
            msg = "未选择图书类别。";
            return false ;
        }

        //验证成功
        return true;
    }
}
