﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;

using BookShopOnline.Model;
using BookShopOnline.Bll;

public partial class Controls_AddBookType : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        
    }

    #region 选中节点
    //选中节点
    protected void SelectedNodeChanged(object sender, EventArgs e)
    {
        string bookTypeID = BookTypeTreeForAdd1._SelectedNode.Value;
        string bookTypeName = BookTypeTreeForAdd1._SelectedNode.Text;

        hidSelectedBookTypeID.Value = bookTypeID;

        TreeNode selectedNode = BookTypeTreeForAdd1._SelectedNode;
        while (selectedNode.Parent != null)
        {
            TreeNode parentNode = selectedNode.Parent;
            selectedNode = parentNode;

            bookTypeName = selectedNode.Text + "->" + bookTypeName;
        }
        lblParentNode.Text = bookTypeName;

        txtSubBookTypeName.Text = "";
        txtSubOrderBy.Text = "";

        txtSelectedBookTypeName.Text = BookTypeTreeForAdd1._SelectedNode.Text;
        txtSelectedOrderBy.Text = BookTypeTreeForAdd1._SelectedNode.ToolTip;

        lblSelectedNode.Text = bookTypeName;
    }
    #endregion

    #region 添加一级节点
    protected void btnAddRoot_Click(object sender, EventArgs e)
    {
        BookType bookType = new BookType();
        bookType.BookTypeName = txtRootBookTypeName.Text;
        bookType.ParentID = -1;

        int orderBy=0;
        if (!Int32.TryParse(txtRootOrderBy.Text, out orderBy))
            return;
        bookType.OrderBy = orderBy;

        BookTypeBll bookTypeBll = new BookTypeBll();
        bookTypeBll.InsertBookType(bookType);

        bookTypeBll.ResetBookTypeListCached();
        BookTypeTreeCached.ResetBookTypeTreeCached();
        BookTypeTreeForAdd1.CreateTree();
    }
    #endregion

    #region 添加子节点
    protected void btnAddSubNode_Click(object sender, EventArgs e)
    {
        if (hidSelectedBookTypeID.Value == null || hidSelectedBookTypeID.Value.Trim() == "")
        {
            return;
        }
       
        BookType bookType = new BookType();
        bookType.BookTypeName = txtSubBookTypeName.Text;

        int parentID = 0;
        if (!Int32.TryParse(hidSelectedBookTypeID.Value, out parentID))
            return;
        bookType.ParentID = parentID;

        int orderBy = 0;
        if (!int.TryParse(txtSubOrderBy.Text, out orderBy))
            return;
        bookType.OrderBy = orderBy;

        BookTypeBll bookTypeBll = new BookTypeBll();
        bookTypeBll.InsertBookType(bookType);

        bookTypeBll.ResetBookTypeListCached();
        BookTypeTreeCached.ResetBookTypeTreeCached();
        BookTypeTreeForAdd1.CreateTree();
    }
    #endregion

    #region 修改选中的节点
    protected void btnModifyNode_Click(object sender, EventArgs e)
    {
        if (hidSelectedBookTypeID.Value == null || hidSelectedBookTypeID.Value.Trim() == "")
        {
            return;
        }

        BookType bookType = new BookType();

        int bookTypeID = 0;
        if (!int.TryParse(hidSelectedBookTypeID.Value, out bookTypeID))
            return;
        bookType.BookTypeID = bookTypeID;

        bookType.BookTypeName = txtSelectedBookTypeName.Text;

        int orderBy = 0;
        if (!int.TryParse(txtSelectedOrderBy.Text, out orderBy))
            return;
        bookType.OrderBy =orderBy;

        BookTypeBll bookTypeBll = new BookTypeBll();
        int returnValue=bookTypeBll.UpdateBookType(bookType);

        bookTypeBll.ResetBookTypeListCached();
        BookTypeTreeCached.ResetBookTypeTreeCached();
        BookTypeTreeForAdd1.CreateTree();
    }
    #endregion

    #region 删除节点
    protected void btnDelNode_Click(object sender, EventArgs e)
    {
        if (BookTypeTreeForAdd1._SelectedNode== null)
        {
            return;
        }

        int  selectedBookTypeID=0;
        if (!int.TryParse(BookTypeTreeForAdd1._SelectedNode.Value, out selectedBookTypeID))
            return;

        BookTypeBll bookTypeBll = new BookTypeBll();
        bookTypeBll.DeleteBookType(selectedBookTypeID);

        lblSelectedNode.Text = "未选择";
        hidSelectedBookTypeID.Value = null;

        bookTypeBll.ResetBookTypeListCached();
        BookTypeTreeCached.ResetBookTypeTreeCached();
        BookTypeTreeForAdd1.CreateTree();
    }
    #endregion
}
