﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="BookList.ascx.cs" Inherits="Controls_BookList" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
  <div class="ModuleTop">
		 <b class="RoundTop">
		 <b class="lr1"></b>
		 <b class="lr2"></b>
		 <b class="lr3"></b>
		 <b class="lr4"></b>
		 </b>
		 <span class="ModuleTopTitle" >图书列表</span>
		 <span class="RecordTip">记录数：<asp:Label ID="lblRecordCount" runat="server" Text=""></asp:Label>条
             <asp:Label ID="lblSearchCondition" runat="server"></asp:Label></span></div>
<div class="Module"> 
<p style="margin:0px;"><b class="bTitle">排序方式：</b>
<asp:RadioButtonList ID="rblOrderType" runat="server"
        RepeatLayout="Flow" RepeatDirection="Horizontal">
    <asp:ListItem Value="1" Selected="True">降序</asp:ListItem>
    <asp:ListItem Value="0">升序</asp:ListItem>
    </asp:RadioButtonList>
    <asp:LinkButton ID="lbtnSoldCount" runat="server" OnClick="lbtnSoldCount_Click">销售量</asp:LinkButton>
    <asp:LinkButton ID="lbtnVisitedCount" runat="server" OnClick="lbtnVisitedCount_Click">人 气</asp:LinkButton>
    <asp:LinkButton ID="lbtnSellPrice" runat="server" OnClick="lbtnSellPrice_Click">销售价格</asp:LinkButton>
    <asp:LinkButton ID="lbtnSellOff" runat="server" OnClick="lbtnSellOff_Click">折 扣</asp:LinkButton>
    <asp:LinkButton ID="lbtnDateAdded" runat="server" OnClick="lbtnDateAdded_Click">上架时间</asp:LinkButton>
    <asp:LinkButton ID="lbtnDatePressed" runat="server" OnClick="lbtnDatePressed_Click">出版时间</asp:LinkButton>
    <asp:HiddenField ID="hiddenOrderByField" runat="server" />
</p>
<hr class="hrDivide" />
<asp:DataList ID="datalistBookList" runat="server" RepeatColumns="1" RepeatDirection="Horizontal" OnItemDataBound="datalistBookList_ItemDataBound" Width="100%">
            <ItemTemplate>
            <p style="float:left; text-align:left;">
            <a href='ShowBookDetail.aspx?BookID=<%#Eval("BookID") %>'>
                <img class="ShorterBookImg" src='<%#Eval("ImgPath") %>' alt='<%#Eval("BookName") %>' /></a>
            <br />
           
            <span class="OriginalPrice"><%#WebTool.FormatMoney( Eval("OriginalPrice"))%></span><span class="SellPrice"><%#WebTool.FormatMoney( Eval("SellPrice")) %>(<%# Eval("SellOff") %>折)</span>
            <br />
            <a href='AddToShoppingCart.aspx?BookID=<%# Eval("BookID") %>' target="shoppingCart">加入购物车</a>
             <a href='AddToFavorites.aspx?BookID=<%#Eval("BookID") %>' target="favorites">收 藏</a>
           </p>
           <p style="text-align:left;margin:5px 5px 5px 5px;">
            书名：<a class="BookLink" href='ShowBookDetail.aspx?BookID=<%#Eval("BookID") %>' title='<%#Eval("BookName") %>'><%#WebTool.SetKeyWordInText(Eval("BookName").ToString(),KeyWord)%></a>
            <br />
           作者：<%#Eval("Author") %><br />
           ISBN：<%#Eval("ISBN") %><br />
           出版社：<%#Eval("Press") %><br />
           出版日期：<%#Eval("DatePressed") %><br />
           分类：<%#Eval("BookTypeName") %><br />
           人气：<%#Eval("VisitedCount") %><br />
           上架时间：<%#WebTool.GetShortDate( Eval("DateAdded").ToString()) %><br />
           
           
           </p>
            </ItemTemplate>
        </asp:DataList>
        <hr class="hrDivide" />
         <webdiyer:AspNetPager ID="AspNetPager1" runat="server" OnPageChanging="AspNetPager1_PageChanging">
                </webdiyer:AspNetPager>
             </div>
            
             <b class="RoundBottom">
			<b class="lr4"></b>
			<b class="lr3"></b>
			<b class="lr2"></b>
			<b class="lr1">
            </b>
			</b>
			 
			 