﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.WebConfig;
using BookShopOnline.Model;

public partial class Controls_BookList : System.Web.UI.UserControl
{
    public event EventHandler EventPageChanging;
    public event EventHandler EventOrderClick;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            SetLinkButtonSelected(lbtnDateAdded.UniqueID);
        }
    }

    public string KeyWord = string.Empty;

    public Label LblSearchCondition
    {
        get { return lblSearchCondition; }
        set { lblSearchCondition = value; }
    }

    public DataList DatalistBookList
    {
        get { return datalistBookList; }
        set { datalistBookList = value; }
    }

    private DataSet bookListDs;

    public DataSet BookListDs
    {
        get { return bookListDs; }
        set { bookListDs = value; }
    }

    public int PageIndex=1;

    public int RecordCount=0;

    public void BindBookList()
    {
        datalistBookList.DataSource = bookListDs;
        datalistBookList.DataBind();

        lblRecordCount.Text = RecordCount.ToString();

        AspNetPager1.PageSize = Config.BookListPageSize;
        AspNetPager1.RecordCount = RecordCount;
        AspNetPager1.CurrentPageIndex = PageIndex;
        AspNetPager1.DataBind();
    }

    //分页
    protected void AspNetPager1_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        PageIndex = e.NewPageIndex;
        EventPageChanging(this, e);

    }

    #region 排序
    //是否降序
    public bool IsDesc
    {
        get
        {
            string orderType = rblOrderType.SelectedValue;
            if (string.Equals(orderType, "1"))//降序
                return true;
            else//升序
                return false;
        }
    }

    //排序字段
    public string OrderByField
    {
        get
        {
            if (string.IsNullOrEmpty(hiddenOrderByField.Value))
                return BookOrderByFields.DateAdded;
            else
                return hiddenOrderByField.Value;
        }
        set
        {
            hiddenOrderByField.Value = value;
        }
    }

    #region 处理选中的排序链接
    private void SetLinkButtonSelected(string uniqueID)
    {
        lbtnDateAdded.Style.Value = "";
        lbtnDatePressed.Style.Value = "";
        lbtnSellOff.Style.Value = "";
        lbtnSellPrice.Style.Value = "";
        lbtnSoldCount.Style.Value = "";
        lbtnVisitedCount.Style.Value = "";

        string cssSelected = "font-size: 13px; color: #ff2828; text-decoration: underline";
        if (string.Equals(uniqueID, lbtnDateAdded.UniqueID))//上架时间
        {
            lbtnDateAdded.Style.Value = cssSelected;
            
            return;
        }

        if (string.Equals(uniqueID, lbtnDatePressed.UniqueID))//出版时间
        {
            lbtnDatePressed.Style.Value = cssSelected;
            return;
        }

        if (string.Equals(uniqueID, lbtnSellOff.UniqueID))//折扣
        {
            lbtnSellOff.Style.Value = cssSelected;
            return;
        }

        if (string.Equals(uniqueID, lbtnSellPrice.UniqueID))//售价
        {
            lbtnSellPrice.Style.Value = cssSelected;
            return;
        }

        if (string.Equals(uniqueID, lbtnSoldCount.UniqueID))//销售量
        {
            lbtnSoldCount.Style.Value = cssSelected;
            return;
        }


        if (string.Equals(uniqueID, lbtnVisitedCount.UniqueID))//人气
        {
            lbtnVisitedCount.Style.Value = cssSelected;
            return;
        }
    }
    #endregion

    //销售量
    protected void lbtnSoldCount_Click(object sender, EventArgs e)
    {
        OrderByField = BookOrderByFields.SoldCount;
        SetLinkButtonSelected(lbtnSoldCount.UniqueID);
        EventOrderClick(this, e);
    }

    //人气
    protected void lbtnVisitedCount_Click(object sender, EventArgs e)
    {
        OrderByField = BookOrderByFields.VisitedCount;
        SetLinkButtonSelected(lbtnVisitedCount.UniqueID);
        EventOrderClick(this, e);
    }

    //售价
    protected void lbtnSellPrice_Click(object sender, EventArgs e)
    {
        OrderByField = BookOrderByFields.SellPrice;
        SetLinkButtonSelected(lbtnSellPrice.UniqueID);
        EventOrderClick(this, e);
    }
    
    //折扣
    protected void lbtnSellOff_Click(object sender, EventArgs e)
    {
        OrderByField = BookOrderByFields.SellOff;
        SetLinkButtonSelected(lbtnSellOff.UniqueID);
        EventOrderClick(this, e);
    }

    //上架时间
    protected void lbtnDateAdded_Click(object sender, EventArgs e)
    {
        OrderByField = BookOrderByFields.DateAdded;
        SetLinkButtonSelected(lbtnDateAdded.UniqueID);
        EventOrderClick(this, e);
    }

    //出版时间
    protected void lbtnDatePressed_Click(object sender, EventArgs e)
    {
        OrderByField = BookOrderByFields.DatePressed;
        SetLinkButtonSelected(lbtnDatePressed.UniqueID);
        EventOrderClick(this, e);
    }

    #endregion

    //
    protected void datalistBookList_ItemDataBound(object sender, DataListItemEventArgs e)
    {
     
    }
}
