﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;

using BookShopOnline.Model;
using BookShopOnline.Bll;

public partial class Controls_BookTypeTreeForAdd : System.Web.UI.UserControl
{
    public event EventHandler SelectedNodeChanged;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (BookTypeTreeCached.BookTypeTreeForAdd == null)
                CreateTree();
            else
                CreateTreeFromCache();
        }
    }

    #region 生成树形菜单
    //创建树形菜单
    public void CreateTree()
    {
        BookTypeBll bookTypeBll = new BookTypeBll();
        IList<BookType> bookTypeList = bookTypeBll.SelectRootBookType();

        TreeView1.Nodes.Clear();
        if(BookTypeTreeCached.BookTypeTreeForAdd!=null)
            BookTypeTreeCached.BookTypeTreeForAdd.Clear();
        BookTypeTreeCached.BookTypeTreeForAdd = new ArrayList();

        foreach (BookType bookType in bookTypeList)
        {
            TreeNode rootNode = new TreeNode();
            rootNode.Value = bookType.BookTypeID.ToString();
            rootNode.Text = bookType.BookTypeName;
            rootNode.ToolTip = bookType.OrderBy.ToString();
            rootNode.Expanded = false;

            CreateNextNode(rootNode, bookType.BookTypeID);

            TreeView1.Nodes.Add(rootNode);
            BookTypeTreeCached.BookTypeTreeForAdd.Add(rootNode);
        }
        TreeView1.DataBind();
    }

    //从缓存中生成树形菜单
    public void CreateTreeFromCache()
    {
        TreeView1.Nodes.Clear();

        ArrayList treeNodesCached = BookTypeTreeCached.BookTypeTreeForAdd;
        for (int i = 0; i < treeNodesCached.Count; i++)
        {
            TreeNode treeNode = (TreeNode)treeNodesCached[i];
            TreeView1.Nodes.Add(treeNode);
        }

        TreeView1.DataBind();
    }

    //创建下一个节点
    private void CreateNextNode(TreeNode parentNode, int parentID)
    {
        BookTypeBll bookTypeBll = new BookTypeBll();
        IList<BookType> bookTypeList = bookTypeBll.SelectSubBooType(parentID);

        foreach (BookType bookType in bookTypeList)
        {
            TreeNode nextNode = new TreeNode();
            nextNode.Value = bookType.BookTypeID.ToString();
            nextNode.Text = bookType.BookTypeName;
            nextNode.ToolTip = bookType.OrderBy.ToString();
            nextNode.Expanded = false;

            parentNode.ChildNodes.Add(nextNode);
            CreateNextNode(nextNode,bookType.BookTypeID);
        }
    }
    #endregion


    public string GetNodeNamesSelected()
    {
        string nodeNamesSelected = "";
        TreeNode selectedNode = TreeView1.SelectedNode;

        if (selectedNode != null)
            nodeNamesSelected = selectedNode.Text;

        while (selectedNode.Parent != null)
        {
            TreeNode parentNode = selectedNode.Parent;
            selectedNode = parentNode;

            nodeNamesSelected = selectedNode.Text + "->" + nodeNamesSelected;
        }

        return nodeNamesSelected;
    }

    public TreeNode _SelectedNode
    {
        get { return TreeView1.SelectedNode; }
    }

    //选择节点
    protected void TreeView1_SelectedNodeChanged(object sender, EventArgs e)
    {
        SelectedNodeChanged(this, e);
    }
}
