﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;

using BookShopOnline.Bll;
using BookShopOnline.Model;

public partial class Controls_BookTypeTreeNavigation : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (BookTypeTreeCached.BookTypeTreeNavigation == null)
                CreateTree();
            else
                CreateTreeFromCache();
        }
    }

    #region 生成树形菜单
    //创建树形菜单
    private void CreateTree()
    {
        BookTypeBll bookTypeBll = new BookTypeBll();
        IList<BookType> bookTypeList = bookTypeBll.SelectRootBookType();

        TreeView1.Nodes.Clear();
        if (BookTypeTreeCached.BookTypeTreeNavigation != null)
            BookTypeTreeCached.BookTypeTreeNavigation.Clear();
        BookTypeTreeCached.BookTypeTreeNavigation = new ArrayList();

        foreach (BookType bookType in bookTypeList)
        {
            TreeNode rootNode = new TreeNode();
            rootNode.Value = bookType.BookTypeID.ToString();
            rootNode.Text = bookType.BookTypeName;
            rootNode.ToolTip = bookType.BookTypeName;
            rootNode.NavigateUrl = string.Format("../BookList.aspx?BookTypeID={0}&BookTypeName={1}", bookType.BookTypeID, Uri.EscapeDataString(bookType.BookTypeName));
            rootNode.Target = "_blank";
            rootNode.Expanded = false;

            CreateNextNode(rootNode, bookType.BookTypeID);

            TreeView1.Nodes.Add(rootNode);
            BookTypeTreeCached.BookTypeTreeNavigation.Add(rootNode);
        }

        TreeView1.DataBind();
    }

    //从缓存中生成树形菜单
    private void CreateTreeFromCache()
    {
        TreeView1.Nodes.Clear();

        ArrayList treeNodesCached = BookTypeTreeCached.BookTypeTreeNavigation;
        for (int i = 0; i < treeNodesCached.Count; i++)
        {
            TreeNode treeNode = (TreeNode)treeNodesCached[i];
            TreeView1.Nodes.Add(treeNode);
        }

        TreeView1.DataBind();
    }

    //创建下一个节点
    private void CreateNextNode(TreeNode parentNode, int parentID)
    {
        BookTypeBll bookTypeBll = new BookTypeBll();
        IList<BookType> bookTypeList = bookTypeBll.SelectSubBooType(parentID);

        foreach (BookType bookType in bookTypeList)
        {
            TreeNode nextNode = new TreeNode();
            nextNode.Value = bookType.BookTypeID.ToString();
            nextNode.Text = bookType.BookTypeName;
            nextNode.ToolTip = bookType.BookTypeName;
            nextNode.NavigateUrl = string.Format("../BookList.aspx?BookTypeID={0}&BookTypeName={1}", bookType.BookTypeID, Uri.EscapeDataString(bookType.BookTypeName));
            nextNode.Target = "_blank";
            nextNode.Expanded = false;

            parentNode.ChildNodes.Add(nextNode);
            CreateNextNode(nextNode, bookType.BookTypeID);
        }
    }
    #endregion
}
