﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;

using BookShopOnline.Model;
using BookShopOnline.Bll;

public partial class Controls_BookTypeTreeNavigationExpanded : System.Web.UI.UserControl
{
    public event EventHandler SelectedNodeChanged;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (BookTypeTreeCached.BookTypeTreeNavigationExpanded == null)
                CreateTree();
            else
                CreateTreeFromCache();
        }
    }

    #region 生成树形菜单
    //创建树形菜单
    public void CreateTree()
    {
        BookTypeBll bookTypeBll = new BookTypeBll();
        IList<BookType> bookTypeList = bookTypeBll.SelectRootBookType();

        TreeView1.Nodes.Clear();
        if (BookTypeTreeCached.BookTypeTreeNavigationExpanded != null)
            BookTypeTreeCached.BookTypeTreeNavigationExpanded.Clear();
       
        BookTypeTreeCached.BookTypeTreeNavigationExpanded = new ArrayList();

        foreach (BookType bookType in bookTypeList)
        {
            TreeNode rootNode = new TreeNode();
            rootNode.Value = bookType.BookTypeID.ToString();
            rootNode.Text = bookType.BookTypeName;
            rootNode.Expanded = true;

            CreateNextNode(rootNode, bookType.BookTypeID);

            TreeView1.Nodes.Add(rootNode);
            BookTypeTreeCached.BookTypeTreeNavigationExpanded.Add(rootNode);
        }
        TreeView1.DataBind();
    }

    //从缓存中生成树形菜单
    public void CreateTreeFromCache()
    {
        TreeView1.Nodes.Clear();

        ArrayList treeNodesCached = BookTypeTreeCached.BookTypeTreeNavigationExpanded;
        for (int i = 0; i < treeNodesCached.Count; i++)
        {
            TreeNode treeNode = (TreeNode)treeNodesCached[i];
            TreeView1.Nodes.Add(treeNode);
        }

        TreeView1.DataBind();
    }

    //创建下一个节点
    private void CreateNextNode(TreeNode parentNode, int parentID)
    {
        BookTypeBll bookTypeBll = new BookTypeBll();
        IList<BookType> bookTypeList = bookTypeBll.SelectSubBooType(parentID);
       
        int deep = 1;
        foreach (BookType bookType in bookTypeList)
        {
            TreeNode nextNode = new TreeNode();
            nextNode.Value = bookType.BookTypeID.ToString();
            nextNode.Text = bookType.BookTypeName;
            if (deep == 1 )
                nextNode.Expanded = true;
            else
                nextNode.Expanded = false;
            deep++;

            parentNode.ChildNodes.Add(nextNode);
            CreateNextNode(nextNode,bookType.BookTypeID);
        }
    }
    #endregion


    public string GetNodeNamesSelected()
    {
        string nodeNamesSelected = "";
        TreeNode selectedNode = TreeView1.SelectedNode;

        if (selectedNode != null)
            nodeNamesSelected = selectedNode.Text;

        while (selectedNode.Parent != null)
        {
            TreeNode parentNode = selectedNode.Parent;
            selectedNode = parentNode;

            nodeNamesSelected = selectedNode.Text + "->" + nodeNamesSelected;
        }

        return nodeNamesSelected;
    }

    public TreeNode _SelectedNode
    {
        get { return TreeView1.SelectedNode; }
    }

    //选择节点
    protected void TreeView1_SelectedNodeChanged(object sender, EventArgs e)
    {
        SelectedNodeChanged(this, e);
    }
}
