﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Model;

public partial class Controls_Header : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        User userLogin = UserState.GetUserLogined();

        if (userLogin!= null)
        {
            lblUserName.Text = userLogin.UserName;
            hyperLogout.Visible = true;
        }
        else
        {
            lblUserName.Text = "";
            hyperLogout.Visible = false;
        }
       
    }
    public Label LblUserName
    {
        get { return lblUserName; }
        set { lblUserName = value; }
    }

    public HyperLink HyperLogout
    {
        get { return hyperLogout; }
        set { hyperLogout = value; }
    }

    public TextBox TxtKeyWord
    {
        get{return txtKeyWord;}
        set{ txtKeyWord=value;}
    }

    public RadioButtonList RblSearchType
    {
        get { return rblSearchType; }
        set { rblSearchType = value; }
    }

    public Button BtnSearch
    {
        get { return btnSearch; }
        set { btnSearch = value; }
    }

    #region 搜索
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        string keyWord =Uri.EscapeDataString(txtKeyWord.Text);
        string searchType = rblSearchType.SelectedValue;

        Response.Redirect(string.Format("~/BookListBySearch.aspx?SearchType={1}&KeyWord={0}", keyWord, searchType), true);
        //WebTool.OpenNewPage(string.Format("BookListBySearch.aspx?KeyWord={0}&SearchType={1}",keyWord,searchType));

    }
    #endregion
}
