﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="OrderDetail.ascx.cs" Inherits="Controls_OrderDetail" %>
<asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" DataKeyNames="OrderDetailID"
    GridLines="Horizontal" OnRowDataBound="GridView1_RowDataBound"
    ShowFooter="True">
    <FooterStyle HorizontalAlign="Right" />
    <Columns>
        <asp:HyperLinkField DataNavigateUrlFields="BookID" DataNavigateUrlFormatString="~/ShowBookDetail.aspx?BookID={0}"
            DataTextField="BookName" HeaderText="图书名称" NavigateUrl="~/ShowBookDetail.aspx" >
            <HeaderStyle HorizontalAlign="Center" />
        </asp:HyperLinkField>
        <asp:BoundField DataField="OriginalPrice" DataFormatString="{0:c}" HeaderText="原价"
            HtmlEncode="False" >
            <HeaderStyle HorizontalAlign="Center" />
        </asp:BoundField>
        <asp:BoundField DataField="SellPrice" DataFormatString="{0:c}" HeaderText="售价" HtmlEncode="False" >
            <HeaderStyle HorizontalAlign="Center" />
        </asp:BoundField>
        <asp:TemplateField HeaderText="数量">
            <FooterTemplate>
                <p class="msg">总数量：<asp:Label ID="lblSumQuatity" runat="server" Text="0"></asp:Label>&nbsp; 总价格：<asp:Label
                    ID="lblSumBookPrice" runat="server" Text="0.00"></asp:Label></p>
            </FooterTemplate>
            <ItemStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:TextBox ID="txtQuatity" runat="server" Text='<%#Eval("Quatity") %>' Width="50px" CssClass="TextBox"></asp:TextBox>
            </ItemTemplate>
            <HeaderStyle HorizontalAlign="Center" />
        </asp:TemplateField>
        <asp:BoundField DataField="TotalSellPrice" HeaderText="总售价" HtmlEncode="False" >
            <HeaderStyle HorizontalAlign="Center" />
        </asp:BoundField>
    </Columns>
</asp:GridView>
