﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Model;
using BookShopOnline.Bll;

public partial class Controls_OrderDetail : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
    }

    #region 获取订单清单
    public void BindOrderDetail(string orderID)
    {
        OrderDetailBll orderDetailBll = new OrderDetailBll();
        GridView1.DataSource= orderDetailBll.SelectOrderDetailByOrderID(orderID);
        GridView1.DataBind();
    }
    #endregion

    #region 统计总数量和总价格
    decimal SumBookPrice = (decimal)0.00;
    int SumQuatity = 0;
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            TextBox txtQuatity = (TextBox)e.Row.FindControl("txtQuatity");
            int quatity = Convert.ToInt32(txtQuatity.Text);
            SumQuatity += quatity;

            decimal totalBookPrice = Convert.ToDecimal(e.Row.Cells[4].Text);
            SumBookPrice += totalBookPrice;
            e.Row.Cells[4].Text = string.Format("{0:c}", totalBookPrice);
        }

        if (e.Row.RowType == DataControlRowType.Footer)
        {
            Label lblSumQuatity = (Label)e.Row.FindControl("lblSumQuatity");
            lblSumQuatity.Text = SumQuatity.ToString();

            Label lblSumBookPrice = (Label)e.Row.FindControl("lblSumBookPrice");
            lblSumBookPrice.Text = string.Format("{0:c}", SumBookPrice);
        }
    }
    #endregion
}
