﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="OrderList.ascx.cs" Inherits="Controls_OrderList" %>
<div id="OrderList" style="margin:5px;width:555px;">
    <span class="msg">订单记录数<asp:Label ID="lblRecordCount" runat="server" Text="0"></asp:Label>条</span><br />
    <asp:GridView ID="gvOrderList" runat="server" AllowPaging="True" AllowSorting="True"
        AutoGenerateColumns="False" GridLines="Horizontal" OnPageIndexChanging="gvOrderList_PageIndexChanging"
        PageSize="20" Width="100%">
        <Columns>
            <asp:HyperLinkField DataNavigateUrlFields="OrderID" DataNavigateUrlFormatString="~/Admin/CheckOrder.aspx?OrderID={0}"
                DataTextField="OrderID" HeaderText="订单ID" NavigateUrl="~/Admin/CheckOrder.aspx"
                Target="_blank" />
            <asp:BoundField DataField="SumPrice" DataFormatString="{0:c}" HeaderText="总费用" HtmlEncode="False" />
            <asp:BoundField DataField="HasPayedPrice" DataFormatString="{0:c}" HeaderText="已付费用"
                HtmlEncode="False" />
            <asp:BoundField DataField="HasNotPayedPrice" DataFormatString="{0:c}" HeaderText="未付费用"
                HtmlEncode="False" />
            <asp:TemplateField HeaderText="订单状态">
                <EditItemTemplate>
                    <asp:TextBox ID="TextBox1" runat="server" Text='<%# Bind("TipName") %>'></asp:TextBox>
                </EditItemTemplate>
                <ItemStyle CssClass="msg" />
                <HeaderStyle HorizontalAlign="Left" />
                <ItemTemplate>
                    <%# Eval("TipName") %>
                    (<%#Eval("UpdateStaticDate") %>)
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="OrderDate" HeaderText="下单时间" />
        </Columns>
    </asp:GridView>
</div>