﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Model;
using BookShopOnline.Bll;

public partial class Controls_OrderList : System.Web.UI.UserControl
{
    public event EventHandler PageIndexChanging;

    protected void Page_Load(object sender, EventArgs e)
    {

    }

    public int PageIndex = 0;
    public DataSet OrderListDS;

    public void BindOrderList()
    {
        gvOrderList.PageIndex = this.PageIndex;
        gvOrderList.DataSource = OrderListDS;
        gvOrderList.DataBind();

        if (OrderListDS != null)
            lblRecordCount.Text = OrderListDS.Tables[0].Rows.Count.ToString();
        else
            lblRecordCount.Text = "0";
    }

    protected void gvOrderList_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        this.PageIndex = e.NewPageIndex;
        PageIndexChanging(this, e);
    }
}
