﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Model;
using BookShopOnline.Bll;

public partial class Controls_OrderListOfUser : System.Web.UI.UserControl
{
    public event EventHandler PageIndexChanging;

    protected void Page_Load(object sender, EventArgs e)
    {

    }

    //绑定订单列表
    public void BindOrderList(int userID)
    {
        DataSet ds = new OrdersBll().SelectOrdersByUserID(userID);
        GridView1.DataSource = ds;
        GridView1.DataBind();

        if (ds != null && ds.Tables[0].Rows.Count == 0)
        {
            lblMsg.Text = "暂无订单！";
        }
    }

    //分页
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        PageIndexChanging(this, e);
    }
}
