﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Model;
using BookShopOnline.Bll;

public partial class Controls_RegisterUser : System.Web.UI.UserControl
{
    public event EventHandler RegisterClick;
    public event EventHandler SaveModifyClick;

    protected void Page_Load(object sender, EventArgs e)
    {

    }

    #region 必选项
    public TextBox TxtUserName
    {
        get { return txtUserName; }
        set { txtUserName = value; }
    }

    public TextBox TxtUserPwd
    {
        get { return txtUserPwd; }
        set { txtUserPwd = value; }
    }

    public TextBox TxtEmail
    {
        get { return txtEmail; }
        set { txtEmail = value; }
    }
    #endregion

    #region 选填项
    public TextBox TxtRealName
    {
        get { return txtRealName; }
        set { txtRealName = value; }
    }

    public TextBox TxtPostalCode
    {
        get { return txtPostalCode; }
        set { txtPostalCode = value; }
    }

    public TextBox TxtPhone
    {
        get { return txtPhone; }
        set { txtPhone = value; }
    }

    public TextBox TxtAddress
    {
        get { return txtAddress; }
        set { txtAddress = value; }
    }
    #endregion

    #region 按钮
    public Button BtnRegister
    {
        get { return btnRegister; }
        set { btnRegister = value; }
    }

    public Button BtnSaveModify
    {
        get { return btnSaveModify; }
        set { btnSaveModify = value; }
    }

    public Button BtnCheckUserName
    {
        get { return btnCheckUserName; }
        set { btnCheckUserName = value; }
    }

    public Button BtnCheckEmail
    {
        get { return btnCheckEmail; }
        set { btnCheckEmail = value; }
    }
    #endregion

    #region 提示
    public Label LblMsg
    {
        get { return lblMsg; }
        set { lblMsg = value; }
    }
    #endregion

    #region 容器panelUserPwd
    public Panel PanelUserPwd
    {
        get { return panelUserPwd; }
        set { panelUserPwd = value; }
    }
    #endregion

    #region 触发按钮事件
    //注册
    protected void btnRegister_Click(object sender, EventArgs e)
    {
        RegisterClick(this, e);
    }

    //保存修改
    protected void btnSaveModify_Click(object sender, EventArgs e)
    {
        SaveModifyClick(this, e);
    }

    //检查用户名是否存在
    protected void btnCheckUserName_Click(object sender, EventArgs e)
    {
        if (txtUserName.Text.Trim() == string.Empty)
            return;

        bool isExist = new UserBll().CheckUserName(TxtUserName.Text);
        lblMsg.Text = "";
        if (isExist)
        {
            lblMsg.Text="该用户名存在！";
        }
        else
        {
            lblMsg.Text="该用户名不存在！";
        }
    }

    //检查Email是否存在
    protected void btnCheckEmail_Click(object sender, EventArgs e)
    {
        if (txtEmail.Text.Trim() == string.Empty)
            return;

        bool isExist = new UserBll().CheckEmail(txtEmail.Text);
        if (isExist)
        {
            lblMsg.Text="该Email存在！";
        }
        else
        {
            lblMsg.Text="该Email不存在！";
        }
    }
    #endregion

}
