﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ShoppingCart.ascx.cs" Inherits="Controls_ShoppingCart" %>
<div id="ShoppingCart">
<div class="ModuleTop">
<b class="RoundTop">
<b class="lr1"></b>
<b class="lr2"></b>
<b class="lr3"></b>
<b class="lr4"></b>
</b>
<span class="ModuleTopTitle">购物车</span>
</div>
<div class="Module">
<asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" DataKeyNames="CartID" GridLines="None" ShowFooter="True" OnRowDataBound="GridView1_RowDataBound" OnRowDeleting="GridView1_RowDeleting">
    <Columns>
        <asp:TemplateField HeaderText="书 名">
       <ItemTemplate><a href='ShowBookDetail.aspx?BookID=<%#Eval("BookID") %>' title='<%#Eval("BookName") %>' target="_blank"><%#Eval("BookName")%></a></ItemTemplate>
        </asp:TemplateField>
        
        <asp:BoundField DataField="OriginalPrice" DataFormatString="{0:c}" HeaderText="原 价" HtmlEncode="False" />
        <asp:BoundField DataField="SellPrice" DataFormatString="{0:c}" HeaderText="售 价" HtmlEncode="False" />
        <asp:TemplateField HeaderText="数 量">
            <ItemTemplate>
                <asp:TextBox ID="txtQuatity" runat="server" Width="50px" Text='<%#Eval("Quatity") %>'></asp:TextBox>
                <asp:RegularExpressionValidator ID="revNums" runat="server" ErrorMessage="**" ControlToValidate="txtQuatity" Font-Size="12px" ValidationExpression="^[1-9]\d*$"></asp:RegularExpressionValidator>
            </ItemTemplate>
            <FooterTemplate>
                总数量：<asp:Label ID="lblSumQuatity" runat="server" Text="0"></asp:Label>&nbsp; 总价格：<asp:Label ID="lblSumBookPrice" runat="server" Text="0.00"></asp:Label>
            </FooterTemplate>
            <ItemStyle HorizontalAlign="Center" />
        </asp:TemplateField>
        <asp:BoundField DataField="TotalSellPrice" HeaderText="总售价" HtmlEncode="False" />
        <asp:CommandField HeaderText="操 作" ShowDeleteButton="True" />
    </Columns>
    <FooterStyle HorizontalAlign="Right" />
</asp:GridView>
<asp:Label ID="lblMsg" runat="server"></asp:Label><br />
<asp:Button ID="btnModifyQuatity" runat="server" Text="修改数量" OnClick="btnModifyQuatity_Click" CssClass="Button" />
<asp:Button ID="btnClearShoppingCart" runat="server" Text="清空购物车" OnClick="btnClearShoppingCart_Click" CssClass="Button" />
<asp:Button ID="btnCheckOut" runat="server" Text="结 算" OnClick="btnCheckOut_Click" Width="100px" CssClass="Button" />
<asp:HyperLink ID="hyperGoBack" runat="server" NavigateUrl="~/Default.aspx">继续购物</asp:HyperLink>
</div>
<b class="RoundBottom">
<b class="lr4"></b>
<b class="lr3"></b>
<b class="lr2"></b>
<b class="lr1"></b>
</b>
</div>