﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Model;
using BookShopOnline.Bll;

public partial class Controls_ShoppingCart : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            BindShoppingCart();

            if (Request.UrlReferrer != null&&Request.UrlReferrer!=Request.Url)
            {
                hyperGoBack.NavigateUrl = Request.UrlReferrer.ToString();
            }
        }
    }

    #region 获取购物车
    public void BindShoppingCart()
    {
        string cartGuid = WebTool.GetCartGuid();

        ShoppingCartBll shoppingCartBll = new ShoppingCartBll();
        GridView1.DataSource = shoppingCartBll.SelectShoppingCartByCartGuid(cartGuid);
        GridView1.DataBind();

        if (GridView1.Rows.Count == 0)
        {
            lblMsg.Text = "购物车当前为空！";
            btnCheckOut.Enabled = false;
            btnModifyQuatity.Enabled = false;
            btnClearShoppingCart.Enabled = false;
        }
    }
    #endregion

    #region 修改数量
    protected void btnModifyQuatity_Click(object sender, EventArgs e)
    {
        IList<ShoppingCart> shoppingCartList = new List<ShoppingCart>();

        foreach(GridViewRow row in GridView1.Rows)
        {
            int cartID=Convert.ToInt32( GridView1.DataKeys[row.RowIndex].Value);

            TextBox txtQuatity = (TextBox)row.FindControl("txtQuatity");
            int quatity=Convert.ToInt32(txtQuatity.Text);

            ShoppingCart shoppingCart = new ShoppingCart();
            shoppingCart.CartID = cartID;
            shoppingCart.Quatity = quatity;

            shoppingCartList.Add(shoppingCart);
        }

        ShoppingCartBll shoppingCartBll = new ShoppingCartBll();
        shoppingCartBll.UpdateShoppingCart(shoppingCartList);

        BindShoppingCart();
    }
    #endregion

    #region 统计总数量和总价格
    decimal SumBookPrice=(decimal)0.00;
    int SumQuatity = 0;
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            TextBox txtQuatity = (TextBox)e.Row.FindControl("txtQuatity");
            int quatity = Convert.ToInt32(txtQuatity.Text);
            SumQuatity += quatity;

            decimal totalBookPrice =Convert.ToDecimal( e.Row.Cells[4].Text);
            SumBookPrice += totalBookPrice;
            e.Row.Cells[4].Text = string.Format("{0:c}", totalBookPrice);
        }

        if (e.Row.RowType == DataControlRowType.Footer)
        {
            Label lblSumQuatity = (Label)e.Row.FindControl("lblSumQuatity");
            lblSumQuatity.Text = SumQuatity.ToString();

            Label lblSumBookPrice = (Label)e.Row.FindControl("lblSumBookPrice");
            lblSumBookPrice.Text = string.Format("{0:c}",SumBookPrice);
        }
    }
    #endregion

    #region 删除
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        string cartID = GridView1.DataKeys[e.RowIndex].Value.ToString();
        ShoppingCartBll shoppingCartBll = new ShoppingCartBll();
        shoppingCartBll.DeleteShoppingCartByCartID(cartID);

        BindShoppingCart();
    }
    #endregion

    #region 清空购物车
    protected void btnClearShoppingCart_Click(object sender, EventArgs e)
    {
        string cartGuid = WebTool.GetCartGuid();
        ShoppingCartBll shoppingCartBll = new ShoppingCartBll();
        shoppingCartBll.DeleteShoppingCartByCartGuid(cartGuid);

        BindShoppingCart();
    }
    #endregion

    #region 结算
    protected void btnCheckOut_Click(object sender, EventArgs e)
    {
        Response.Redirect("~/AddOrder.aspx");
    }
    #endregion
}
