﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ShoppingCartList.ascx.cs" Inherits="Controls_ShoppingCartList" %>
<asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" DataKeyNames="CartID"
    GridLines="Horizontal" OnRowDataBound="GridView1_RowDataBound"
    ShowFooter="True">
    <FooterStyle HorizontalAlign="Right" />
    <Columns>
        <asp:TemplateField HeaderText="图书名称">
       <ItemTemplate><a href='../Web/ShowBookDetail.aspx?BookID=<%#Eval("BookID") %>' title='<%#Eval("BookName") %>' target="_blank"><%#Eval("BookName") %></a></ItemTemplate>
            <HeaderStyle HorizontalAlign="Center" />
        </asp:TemplateField>
        <asp:BoundField DataField="OriginalPrice" DataFormatString="{0:c}" HeaderText="原价"
            HtmlEncode="False" >
            <HeaderStyle HorizontalAlign="Center" />
        </asp:BoundField>
        <asp:BoundField DataField="SellPrice" DataFormatString="{0:c}" HeaderText="售价" HtmlEncode="False" >
            <HeaderStyle HorizontalAlign="Center" />
        </asp:BoundField>
        <asp:TemplateField HeaderText="数量">
            <FooterTemplate>
               <p class="msg"> 总数量：<asp:Label ID="lblSumQuatity" runat="server" Text="0"></asp:Label>&nbsp; 总价格：<asp:Label
                    ID="lblSumBookPrice" runat="server" Text="0.00"></asp:Label>
              </p>
            </FooterTemplate>
            <ItemStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:TextBox ID="txtQuatity" runat="server" Text='<%#Eval("Quatity") %>' Width="50px"></asp:TextBox>
            </ItemTemplate>
            <HeaderStyle HorizontalAlign="Center" />
        </asp:TemplateField>
        <asp:BoundField DataField="TotalSellPrice" HeaderText="总售价" HtmlEncode="False" >
            <HeaderStyle HorizontalAlign="Center" />
        </asp:BoundField>
    </Columns>
</asp:GridView>
<asp:Label ID="lblMsg" runat="server" Text=""></asp:Label>
