﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Model;
using BookShopOnline.Bll;

public partial class Controls_ShoppingCartList : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            BindShoppingCart();
        }
    }

    #region 获取购物车
    public void BindShoppingCart()
    {
        string cartGuid = WebTool.GetCartGuid();

        ShoppingCartBll shoppingCartBll = new ShoppingCartBll();
        GridView1.DataSource = shoppingCartBll.SelectShoppingCartByCartGuid(cartGuid);
        GridView1.DataBind();

        if (GridView1.Rows.Count == 0)
        {
            lblMsg.Text = "购物车当前为空！";
        }
    }
    #endregion

    #region 统计总数量和总价格
    decimal SumBookPrice = (decimal)0.00;
    int SumQuatity = 0;
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            TextBox txtQuatity = (TextBox)e.Row.FindControl("txtQuatity");
            int quatity = Convert.ToInt32(txtQuatity.Text);
            SumQuatity += quatity;

            decimal totalBookPrice = Convert.ToDecimal(e.Row.Cells[4].Text);
            SumBookPrice += totalBookPrice;
            e.Row.Cells[4].Text = string.Format("{0:c}", totalBookPrice);
        }

        if (e.Row.RowType == DataControlRowType.Footer)
        {
            Label lblSumQuatity = (Label)e.Row.FindControl("lblSumQuatity");
            lblSumQuatity.Text = SumQuatity.ToString();

            Label lblSumBookPrice = (Label)e.Row.FindControl("lblSumBookPrice");
            lblSumBookPrice.Text = string.Format("{0:c}", SumBookPrice);
        }
    }
    #endregion
}
