﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Model;
using BookShopOnline.Bll;

public partial class PayPage:Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        UserState.CheckUserLogin();

        if (!IsPostBack)
        {
            lblOrderID.Text = PageHelper.GetUrlParmValue(UrlParmName.OrderID);
            lblHasNotPayedPrice.Text = WebTool.FormatMoney(PageHelper.GetSession(SessionName.HasNotPayedPrice));
            txtPayPirce.Text = PageHelper.GetSession(SessionName.HasNotPayedPrice).ToString();

            HyperLink1.NavigateUrl += "?OrderID=" + PageHelper.GetUrlParmValue(UrlParmName.OrderID);
        }
    }

    protected void btnPay_Click(object sender, EventArgs e)
    {
        User userLogined = UserState.GetUserLogined();

        decimal payPrice = Convert.ToDecimal(txtPayPirce.Text);

        bool result = new OrdersBll().PayForOrders(userLogined.UserID, PageHelper.GetUrlParmValue(UrlParmName.OrderID), payPrice);

        if (result==true)
        {
            lblMsg.Text = "付款成功!";
        }
        else
        {
            lblMsg.Text = "付款失败！";
        }
    }
}
