﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Model;
using BookShopOnline.Bll;

public partial class RegisterUser:Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            RegisterUser1.TxtUserName.Focus();
            RegisterUser1.BtnSaveModify.Enabled = false;
            RegisterUser1.BtnSaveModify.Visible = false;

            string fromUrl = PageHelper.GetFromUrl();

            hyperFromUrl.NavigateUrl = fromUrl;
        }
    }

    #region 注册
    protected void RegisterClick(object sender, EventArgs e)
    {
        if (!Page.IsValid)
            return;

        BookShopOnline.Model.User user = new User();
        user.RoleID =(int) Role.RegisterUser;
        //必填项
        user.UserName = RegisterUser1.TxtUserName.Text;
        user.UserPwd = RegisterUser1.TxtUserPwd.Text;
        user.Email = RegisterUser1.TxtEmail.Text;
        //选填项
        user.RealName = RegisterUser1.TxtRealName.Text;
        user.PostalCode = RegisterUser1.TxtPostalCode.Text;
        user.Phone = RegisterUser1.TxtPhone.Text;
        user.Address = RegisterUser1.TxtAddress.Text;

        int result = new UserBll().InsertUser(user);

        if (result == -2)
        {
            RegisterUser1.LblMsg.Text = "注册失败！该用户名已存在。";
            return;
        }

        if (result == -3)
        {
            RegisterUser1.LblMsg.Text = "注册失败！该Email已存在。";
            return;
        }

        if (result==1)
        {
            Response.Redirect("RegisterResult.aspx?BackUrl=" + hyperFromUrl.NavigateUrl);
        }
        else
        {
            RegisterUser1.LblMsg.Text = "注册失败！检查输入并重试。";
        }
    }
    #endregion
}
