﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Bll;

public partial class ShowBookDetail : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            BindBookDetail();
            WebTool.SaveBookIDInCookies(BookID);
            BooksVisited1.BindBooksVisited(WebTool.GetBookIDInCookies());
        }
    }

    private string BookID
    {
        get
        {
            if (Request.QueryString["BookID"] == null)
                return null;

            return Request.QueryString["BookID"].ToString();
        }
    }

    private void BindBookDetail()
    {
        if (string.IsNullOrEmpty(BookID))
            return;

        DataSet ds=new BookBll().SelectBookByBookID(BookID);
        fvBookDetail.DataSource = ds;
        fvBookDetail.DataBind();

        if (ds == null || ds.Tables[0].Rows.Count == 0)
            lblMsg.Visible = true;
    }


}
