﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Bll;
using BookShopOnline.Utility;
using BookShopOnline.Model;

public partial class UserCenter_EditPwd:Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        UserState.CheckUserLogin();
    }

    protected void OnSubmitClick(object sender, EventArgs e)
    {
        User userLogined = UserState.GetUserLogined();

        string oldPwd = EditPwd1._OldPwd.Text;
        string newPwd = EditPwd1._NewPwd.Text;

        oldPwd=Password.EncryptMD5(oldPwd);

        if (!string.Equals(oldPwd, userLogined.UserPwd))
        {
            EditPwd1._Msg.Text = "原密码错误！请重新输入。";
            return;
        }

        bool success = new UserBll().EditPwd(userLogined.UserID, newPwd);

        if (success)
        {
            EditPwd1._Msg.Text = "密码修改成功！";
        }
        else
        {
            EditPwd1._Msg.Text = "密码修改失败！请重试。";
        }
    }
}
