﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Bll;
using BookShopOnline.Model;

public partial class UserCenter_Favorites : Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        UserState.CheckUserLogin();


        if (!IsPostBack)
        {
            User userLogined = UserState.GetUserLogined();
            string backUrl = PageHelper.GetUrlParmValue(UrlParmName.BackUrl);

            if (string.IsNullOrEmpty(backUrl))
            {
                hyperGoBack.Visible = false;
            }
            else
            {
                hyperGoBack.NavigateUrl=backUrl;
            }
            Favorites1.BindFavorites(userLogined.UserID);
        }
    }

    protected void Favorites_RowDeleting(object sender, EventArgs e)
    {
        int returnValue= new FavoritesBll().DeleteFavoritesByID(Favorites1.FavoritesID);

        if(returnValue>0)
            Favorites1.BindFavorites(UserState.GetUserLogined().UserID);
    }
}
