﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BookShopOnline.Bll;
using BookShopOnline.Model;

public partial class UserCenter_ModifyOrder:Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        UserState.CheckUserLogin();

        if (!IsPostBack)
        {
            AddOrder1._btnAddOrders.Enabled = false;
            AddOrder1._btnAddOrders.Visible = false;

            string orderID = PageHelper.GetUrlParmValue(UrlParmName.OrderID);
            if (!string.IsNullOrEmpty(orderID))
            {
                OrderDetail1.BindOrderDetail(orderID);
                BindOrderInfo(orderID);
            }
        }
    }

    private void BindOrderInfo(string orderID)
    {
        DataSet ds = new OrdersBll().SelectOrdersByOrderID(orderID);

        if (ds == null && ds.Tables[0].Rows.Count == 0)
            return;

        DataRow dr = ds.Tables[0].Rows[0];

        AddOrder1._txtReceiverName.Text = dr["ReceiverName"].ToString();
        AddOrder1._txtReceiverAddress.Text = dr["ReceiverAddress"].ToString();
        AddOrder1._txtReceiverPhone.Text = dr["ReceiverPhone"].ToString();
        AddOrder1._txtReceiverPostalCode.Text = dr["ReceiverPostalCode"].ToString();

        AddOrder1._rblPortType.SelectedValue = dr["PortTypeID"].ToString();
        AddOrder1._rblPayType.SelectedValue = dr["PayTypeID"].ToString();
    }

    protected void ModifyOrdersClick(object sender, EventArgs e)
    {
        User userLogined = UserState.GetUserLogined();
        string orderID = PageHelper.GetUrlParmValue(UrlParmName.OrderID);

        if (string.IsNullOrEmpty(orderID))
            return;

        Orders orders = new Orders();
        orders.UserID = userLogined.UserID;
        orders.OrderID = orderID;

        orders.ReceiverName = AddOrder1._txtReceiverName.Text;
        orders.ReceiverPostalCode = AddOrder1._txtReceiverPostalCode.Text;
        orders.ReceiverPhone = AddOrder1._txtReceiverPhone.Text;
        orders.ReceiverAddress = AddOrder1._txtReceiverAddress.Text;

        orders.PortTypeID = Convert.ToInt32(AddOrder1._rblPortType.SelectedValue);
        orders.PayTypeID = Convert.ToInt32(AddOrder1._rblPayType.SelectedValue);

        int result = new OrdersBll().UpdateOrders(orders);

        if (result > 0)
        {
            Response.Redirect("ShowOrder.aspx?OrderId=" + orderID);
        }
        else
        {
            AddOrder1._lblMsg.Text = "修改失败！";
        }

    }
}
